package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RuleArn,
  RuleName,
  CreatedAtDate,
  IsDisabled,
  TopicPattern
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TopicRuleListItem(
    ruleArn: Optional[RuleArn] = Optional.Absent,
    ruleName: Optional[RuleName] = Optional.Absent,
    topicPattern: Optional[TopicPattern] = Optional.Absent,
    createdAt: Optional[CreatedAtDate] = Optional.Absent,
    ruleDisabled: Optional[IsDisabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRuleListItem = {
    import TopicRuleListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRuleListItem
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(
        topicPattern.map(value => TopicPattern.unwrap(value): java.lang.String)
      )(_.topicPattern)
      .optionallyWith(
        createdAt.map(value => CreatedAtDate.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        ruleDisabled.map(value => IsDisabled.unwrap(value): java.lang.Boolean)
      )(_.ruleDisabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRuleListItem.ReadOnly =
    zio.aws.iot.model.TopicRuleListItem.wrap(buildAwsValue())
}
object TopicRuleListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRuleListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRuleListItem =
      zio.aws.iot.model.TopicRuleListItem(
        ruleArn.map(value => value),
        ruleName.map(value => value),
        topicPattern.map(value => value),
        createdAt.map(value => value),
        ruleDisabled.map(value => value)
      )
    def ruleArn: Optional[RuleArn]
    def ruleName: Optional[RuleName]
    def topicPattern: Optional[TopicPattern]
    def createdAt: Optional[CreatedAtDate]
    def ruleDisabled: Optional[IsDisabled]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getTopicPattern: ZIO[Any, AwsError, TopicPattern] =
      AwsError.unwrapOptionField("topicPattern", topicPattern)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAtDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getRuleDisabled: ZIO[Any, AwsError, IsDisabled] =
      AwsError.unwrapOptionField("ruleDisabled", ruleDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleListItem
  ) extends zio.aws.iot.model.TopicRuleListItem.ReadOnly {
    override val ruleArn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value => zio.aws.iot.model.primitives.RuleArn(value))
    override val ruleName: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.iot.model.primitives.RuleName(value))
    override val topicPattern: Optional[TopicPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.topicPattern())
      .map(value => zio.aws.iot.model.primitives.TopicPattern(value))
    override val createdAt: Optional[CreatedAtDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.CreatedAtDate(value))
    override val ruleDisabled: Optional[IsDisabled] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleDisabled())
      .map(value => zio.aws.iot.model.primitives.IsDisabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleListItem
  ): zio.aws.iot.model.TopicRuleListItem.ReadOnly = new Wrapper(impl)
}
