package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  KeyValue,
  EnableCachingForHttp,
  KeyName,
  AuthorizerName,
  AuthorizerFunctionArn,
  TokenKeyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAuthorizerRequest(
    authorizerName: AuthorizerName,
    authorizerFunctionArn: Optional[AuthorizerFunctionArn] = Optional.Absent,
    tokenKeyName: Optional[TokenKeyName] = Optional.Absent,
    tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]] = Optional.Absent,
    status: Optional[zio.aws.iot.model.AuthorizerStatus] = Optional.Absent,
    enableCachingForHttp: Optional[EnableCachingForHttp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest = {
    import UpdateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .optionallyWith(
        authorizerFunctionArn.map(value =>
          AuthorizerFunctionArn.unwrap(value): java.lang.String
        )
      )(_.authorizerFunctionArn)
      .optionallyWith(
        tokenKeyName.map(value => TokenKeyName.unwrap(value): java.lang.String)
      )(_.tokenKeyName)
      .optionallyWith(
        tokenSigningPublicKeys.map(value =>
          value
            .map({ case (key, value) =>
              (KeyName.unwrap(key): java.lang.String) -> (KeyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tokenSigningPublicKeys)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        enableCachingForHttp.map(value =>
          EnableCachingForHttp.unwrap(value): java.lang.Boolean
        )
      )(_.enableCachingForHttp)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.UpdateAuthorizerRequest.wrap(buildAwsValue())
}
object UpdateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateAuthorizerRequest =
      zio.aws.iot.model.UpdateAuthorizerRequest(
        authorizerName,
        authorizerFunctionArn.map(value => value),
        tokenKeyName.map(value => value),
        tokenSigningPublicKeys.map(value => value),
        status.map(value => value),
        enableCachingForHttp.map(value => value)
      )
    def authorizerName: AuthorizerName
    def authorizerFunctionArn: Optional[AuthorizerFunctionArn]
    def tokenKeyName: Optional[TokenKeyName]
    def tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]]
    def status: Optional[zio.aws.iot.model.AuthorizerStatus]
    def enableCachingForHttp: Optional[EnableCachingForHttp]
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
    def getAuthorizerFunctionArn: ZIO[Any, AwsError, AuthorizerFunctionArn] =
      AwsError.unwrapOptionField("authorizerFunctionArn", authorizerFunctionArn)
    def getTokenKeyName: ZIO[Any, AwsError, TokenKeyName] =
      AwsError.unwrapOptionField("tokenKeyName", tokenKeyName)
    def getTokenSigningPublicKeys: ZIO[Any, AwsError, Map[KeyName, KeyValue]] =
      AwsError.unwrapOptionField(
        "tokenSigningPublicKeys",
        tokenSigningPublicKeys
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEnableCachingForHttp: ZIO[Any, AwsError, EnableCachingForHttp] =
      AwsError.unwrapOptionField("enableCachingForHttp", enableCachingForHttp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest
  ) extends zio.aws.iot.model.UpdateAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
    override val authorizerFunctionArn: Optional[AuthorizerFunctionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerFunctionArn())
        .map(value => zio.aws.iot.model.primitives.AuthorizerFunctionArn(value))
    override val tokenKeyName: Optional[TokenKeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenKeyName())
      .map(value => zio.aws.iot.model.primitives.TokenKeyName(value))
    override val tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenSigningPublicKeys())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .KeyName(key) -> zio.aws.iot.model.primitives.KeyValue(value)
            })
            .toMap
        )
    override val status: Optional[zio.aws.iot.model.AuthorizerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.AuthorizerStatus.wrap(value))
    override val enableCachingForHttp: Optional[EnableCachingForHttp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCachingForHttp())
        .map(value => zio.aws.iot.model.primitives.EnableCachingForHttp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest
  ): zio.aws.iot.model.UpdateAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
