package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCertificateRequest(
    certificateId: CertificateId,
    newStatus: zio.aws.iot.model.CertificateStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateCertificateRequest = {
    import UpdateCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .newStatus(newStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateCertificateRequest.ReadOnly =
    zio.aws.iot.model.UpdateCertificateRequest.wrap(buildAwsValue())
}
object UpdateCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateCertificateRequest =
      zio.aws.iot.model.UpdateCertificateRequest(certificateId, newStatus)
    def certificateId: CertificateId
    def newStatus: zio.aws.iot.model.CertificateStatus
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getNewStatus: ZIO[Any, Nothing, zio.aws.iot.model.CertificateStatus] =
      ZIO.succeed(newStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateCertificateRequest
  ) extends zio.aws.iot.model.UpdateCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
    override val newStatus: zio.aws.iot.model.CertificateStatus =
      zio.aws.iot.model.CertificateStatus.wrap(impl.newStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateCertificateRequest
  ): zio.aws.iot.model.UpdateCertificateRequest.ReadOnly = new Wrapper(impl)
}
