package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AwsArn, VpcId, SecurityGroupId, SubnetId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcDestinationConfiguration(
    subnetIds: Iterable[SubnetId],
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    vpcId: VpcId,
    roleArn: AwsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.VpcDestinationConfiguration = {
    import VpcDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.VpcDestinationConfiguration
      .builder()
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.VpcDestinationConfiguration.ReadOnly =
    zio.aws.iot.model.VpcDestinationConfiguration.wrap(buildAwsValue())
}
object VpcDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.VpcDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.VpcDestinationConfiguration =
      zio.aws.iot.model.VpcDestinationConfiguration(
        subnetIds,
        securityGroups.map(value => value),
        vpcId,
        roleArn
      )
    def subnetIds: List[SubnetId]
    def securityGroups: Optional[List[SecurityGroupId]]
    def vpcId: VpcId
    def roleArn: AwsArn
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.VpcDestinationConfiguration
  ) extends zio.aws.iot.model.VpcDestinationConfiguration.ReadOnly {
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val vpcId: VpcId = zio.aws.iot.model.primitives.VpcId(impl.vpcId())
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.VpcDestinationConfiguration
  ): zio.aws.iot.model.VpcDestinationConfiguration.ReadOnly = new Wrapper(impl)
}
