package zio.aws.iot
import zio.aws.iot.model.primitives.ThingGroupId.Type
import java.time.Instant
import zio.aws.iot.model.primitives.{
  SubnetId,
  ParameterKey,
  Percent,
  MetricName,
  IndexName,
  TargetArn,
  RoleAlias,
  ProcessingTargetName,
  KeyValue,
  AttributeName,
  ThingName,
  ReasonForNonComplianceCode,
  SecurityGroupId,
  ParameterValue,
  Cidr,
  DetailsValue,
  PolicyName,
  ViolationId,
  PrincipalArn,
  KeyName,
  Port,
  HttpHeaderName,
  AuditCheckName,
  Resource,
  Value,
  ResourceLogicalId,
  ShadowName,
  PolicyDocument,
  DetailsKey,
  AttributeKey,
  Number,
  FindingId,
  S3FileUrl,
  ResourceArn,
  BehaviorMetric,
  DimensionName,
  HttpHeaderValue,
  AcmCertificateArn,
  MissingContextValue,
  Parameter,
  PolicyTarget,
  Target,
  TaskId,
  Environment,
  DimensionStringValue,
  StringValue,
  AttributeValue,
  AggregationTypeValue,
  TagKey,
  ThingGroupName,
  MitigationActionName
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AbortThresholdPercentage extends Subtype[Double]
    type AbortThresholdPercentage =
      zio.aws.iot.model.primitives.AbortThresholdPercentage.Type
    object AcmCertificateArn extends Subtype[String]
    type AcmCertificateArn = zio.aws.iot.model.primitives.AcmCertificateArn.Type
    object AggregationField extends Subtype[String]
    type AggregationField = zio.aws.iot.model.primitives.AggregationField.Type
    object AggregationTypeValue extends Subtype[String]
    type AggregationTypeValue =
      zio.aws.iot.model.primitives.AggregationTypeValue.Type
    object AlarmName extends Subtype[String]
    type AlarmName = zio.aws.iot.model.primitives.AlarmName.Type
    object AlertTargetArn extends Subtype[String]
    type AlertTargetArn = zio.aws.iot.model.primitives.AlertTargetArn.Type
    object AllowAuthorizerOverride extends Subtype[Boolean]
    type AllowAuthorizerOverride =
      zio.aws.iot.model.primitives.AllowAuthorizerOverride.Type
    object AllowAutoRegistration extends Subtype[Boolean]
    type AllowAutoRegistration =
      zio.aws.iot.model.primitives.AllowAutoRegistration.Type
    object ApproximateSecondsBeforeTimedOut extends Subtype[Long]
    type ApproximateSecondsBeforeTimedOut =
      zio.aws.iot.model.primitives.ApproximateSecondsBeforeTimedOut.Type
    object AscendingOrder extends Subtype[Boolean]
    type AscendingOrder = zio.aws.iot.model.primitives.AscendingOrder.Type
    object AssetId extends Subtype[String]
    type AssetId = zio.aws.iot.model.primitives.AssetId.Type
    object AssetPropertyAlias extends Subtype[String]
    type AssetPropertyAlias =
      zio.aws.iot.model.primitives.AssetPropertyAlias.Type
    object AssetPropertyBooleanValue extends Subtype[String]
    type AssetPropertyBooleanValue =
      zio.aws.iot.model.primitives.AssetPropertyBooleanValue.Type
    object AssetPropertyDoubleValue extends Subtype[String]
    type AssetPropertyDoubleValue =
      zio.aws.iot.model.primitives.AssetPropertyDoubleValue.Type
    object AssetPropertyEntryId extends Subtype[String]
    type AssetPropertyEntryId =
      zio.aws.iot.model.primitives.AssetPropertyEntryId.Type
    object AssetPropertyId extends Subtype[String]
    type AssetPropertyId = zio.aws.iot.model.primitives.AssetPropertyId.Type
    object AssetPropertyIntegerValue extends Subtype[String]
    type AssetPropertyIntegerValue =
      zio.aws.iot.model.primitives.AssetPropertyIntegerValue.Type
    object AssetPropertyOffsetInNanos extends Subtype[String]
    type AssetPropertyOffsetInNanos =
      zio.aws.iot.model.primitives.AssetPropertyOffsetInNanos.Type
    object AssetPropertyQuality extends Subtype[String]
    type AssetPropertyQuality =
      zio.aws.iot.model.primitives.AssetPropertyQuality.Type
    object AssetPropertyStringValue extends Subtype[String]
    type AssetPropertyStringValue =
      zio.aws.iot.model.primitives.AssetPropertyStringValue.Type
    object AssetPropertyTimeInSeconds extends Subtype[String]
    type AssetPropertyTimeInSeconds =
      zio.aws.iot.model.primitives.AssetPropertyTimeInSeconds.Type
    object AttributeKey extends Subtype[String]
    type AttributeKey = zio.aws.iot.model.primitives.AttributeKey.Type
    object AttributeName extends Subtype[String]
    type AttributeName = zio.aws.iot.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue = zio.aws.iot.model.primitives.AttributeValue.Type
    object AuditCheckName extends Subtype[String]
    type AuditCheckName = zio.aws.iot.model.primitives.AuditCheckName.Type
    object AuditDescription extends Subtype[String]
    type AuditDescription = zio.aws.iot.model.primitives.AuditDescription.Type
    object AuditTaskId extends Subtype[String]
    type AuditTaskId = zio.aws.iot.model.primitives.AuditTaskId.Type
    object AuthorizerArn extends Subtype[String]
    type AuthorizerArn = zio.aws.iot.model.primitives.AuthorizerArn.Type
    object AuthorizerFunctionArn extends Subtype[String]
    type AuthorizerFunctionArn =
      zio.aws.iot.model.primitives.AuthorizerFunctionArn.Type
    object AuthorizerName extends Subtype[String]
    type AuthorizerName = zio.aws.iot.model.primitives.AuthorizerName.Type
    object Average extends Subtype[Double]
    type Average = zio.aws.iot.model.primitives.Average.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId = zio.aws.iot.model.primitives.AwsAccountId.Type
    object AwsArn extends Subtype[String]
    type AwsArn = zio.aws.iot.model.primitives.AwsArn.Type
    object AwsIotJobArn extends Subtype[String]
    type AwsIotJobArn = zio.aws.iot.model.primitives.AwsIotJobArn.Type
    object AwsIotJobId extends Subtype[String]
    type AwsIotJobId = zio.aws.iot.model.primitives.AwsIotJobId.Type
    object AwsIotSqlVersion extends Subtype[String]
    type AwsIotSqlVersion = zio.aws.iot.model.primitives.AwsIotSqlVersion.Type
    object AwsJobAbortCriteriaAbortThresholdPercentage extends Subtype[Double]
    type AwsJobAbortCriteriaAbortThresholdPercentage =
      zio.aws.iot.model.primitives.AwsJobAbortCriteriaAbortThresholdPercentage.Type
    object AwsJobAbortCriteriaMinimumNumberOfExecutedThings extends Subtype[Int]
    type AwsJobAbortCriteriaMinimumNumberOfExecutedThings =
      zio.aws.iot.model.primitives.AwsJobAbortCriteriaMinimumNumberOfExecutedThings.Type
    object AwsJobRateIncreaseCriteriaNumberOfThings extends Subtype[Int]
    type AwsJobRateIncreaseCriteriaNumberOfThings =
      zio.aws.iot.model.primitives.AwsJobRateIncreaseCriteriaNumberOfThings.Type
    object AwsJobRolloutIncrementFactor extends Subtype[Double]
    type AwsJobRolloutIncrementFactor =
      zio.aws.iot.model.primitives.AwsJobRolloutIncrementFactor.Type
    object AwsJobRolloutRatePerMinute extends Subtype[Int]
    type AwsJobRolloutRatePerMinute =
      zio.aws.iot.model.primitives.AwsJobRolloutRatePerMinute.Type
    object AwsJobTimeoutInProgressTimeoutInMinutes extends Subtype[Long]
    type AwsJobTimeoutInProgressTimeoutInMinutes =
      zio.aws.iot.model.primitives.AwsJobTimeoutInProgressTimeoutInMinutes.Type
    object BatchMode extends Subtype[Boolean]
    type BatchMode = zio.aws.iot.model.primitives.BatchMode.Type
    object BehaviorMetric extends Subtype[String]
    type BehaviorMetric = zio.aws.iot.model.primitives.BehaviorMetric.Type
    object BehaviorName extends Subtype[String]
    type BehaviorName = zio.aws.iot.model.primitives.BehaviorName.Type
    object BillingGroupArn extends Subtype[String]
    type BillingGroupArn = zio.aws.iot.model.primitives.BillingGroupArn.Type
    object BillingGroupDescription extends Subtype[String]
    type BillingGroupDescription =
      zio.aws.iot.model.primitives.BillingGroupDescription.Type
    object BillingGroupId extends Subtype[String]
    type BillingGroupId = zio.aws.iot.model.primitives.BillingGroupId.Type
    object BillingGroupName extends Subtype[String]
    type BillingGroupName = zio.aws.iot.model.primitives.BillingGroupName.Type
    object BooleanKey extends Subtype[Boolean]
    type BooleanKey = zio.aws.iot.model.primitives.BooleanKey.Type
    object BooleanWrapperObject extends Subtype[Boolean]
    type BooleanWrapperObject =
      zio.aws.iot.model.primitives.BooleanWrapperObject.Type
    object BucketKeyValue extends Subtype[String]
    type BucketKeyValue = zio.aws.iot.model.primitives.BucketKeyValue.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.iot.model.primitives.BucketName.Type
    object CanceledChecksCount extends Subtype[Int]
    type CanceledChecksCount =
      zio.aws.iot.model.primitives.CanceledChecksCount.Type
    object CanceledFindingsCount extends Subtype[Long]
    type CanceledFindingsCount =
      zio.aws.iot.model.primitives.CanceledFindingsCount.Type
    object CanceledThings extends Subtype[Int]
    type CanceledThings = zio.aws.iot.model.primitives.CanceledThings.Type
    object CertificateArn extends Subtype[String]
    type CertificateArn = zio.aws.iot.model.primitives.CertificateArn.Type
    object CertificateId extends Subtype[String]
    type CertificateId = zio.aws.iot.model.primitives.CertificateId.Type
    object CertificateName extends Subtype[String]
    type CertificateName = zio.aws.iot.model.primitives.CertificateName.Type
    object CertificatePathOnDevice extends Subtype[String]
    type CertificatePathOnDevice =
      zio.aws.iot.model.primitives.CertificatePathOnDevice.Type
    object CertificatePem extends Subtype[String]
    type CertificatePem = zio.aws.iot.model.primitives.CertificatePem.Type
    object CertificateSigningRequest extends Subtype[String]
    type CertificateSigningRequest =
      zio.aws.iot.model.primitives.CertificateSigningRequest.Type
    object ChannelName extends Subtype[String]
    type ChannelName = zio.aws.iot.model.primitives.ChannelName.Type
    object CheckCompliant extends Subtype[Boolean]
    type CheckCompliant = zio.aws.iot.model.primitives.CheckCompliant.Type
    object Cidr extends Subtype[String]
    type Cidr = zio.aws.iot.model.primitives.Cidr.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.iot.model.primitives.ClientId.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.iot.model.primitives.ClientRequestToken.Type
    object Code extends Subtype[String]
    type Code = zio.aws.iot.model.primitives.Code.Type
    object CognitoIdentityPoolId extends Subtype[String]
    type CognitoIdentityPoolId =
      zio.aws.iot.model.primitives.CognitoIdentityPoolId.Type
    object Comment extends Subtype[String]
    type Comment = zio.aws.iot.model.primitives.Comment.Type
    object CompliantChecksCount extends Subtype[Int]
    type CompliantChecksCount =
      zio.aws.iot.model.primitives.CompliantChecksCount.Type
    object ConfirmationToken extends Subtype[String]
    type ConfirmationToken = zio.aws.iot.model.primitives.ConfirmationToken.Type
    object ConnectivityTimestamp extends Subtype[Long]
    type ConnectivityTimestamp =
      zio.aws.iot.model.primitives.ConnectivityTimestamp.Type
    object ConsecutiveDatapointsToAlarm extends Subtype[Int]
    type ConsecutiveDatapointsToAlarm =
      zio.aws.iot.model.primitives.ConsecutiveDatapointsToAlarm.Type
    object ConsecutiveDatapointsToClear extends Subtype[Int]
    type ConsecutiveDatapointsToClear =
      zio.aws.iot.model.primitives.ConsecutiveDatapointsToClear.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.iot.model.primitives.Count.Type
    object CreatedAtDate extends Subtype[Instant]
    type CreatedAtDate = zio.aws.iot.model.primitives.CreatedAtDate.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate = zio.aws.iot.model.primitives.CreationDate.Type
    object CredentialDurationSeconds extends Subtype[Int]
    type CredentialDurationSeconds =
      zio.aws.iot.model.primitives.CredentialDurationSeconds.Type
    object CustomMetricArn extends Subtype[String]
    type CustomMetricArn = zio.aws.iot.model.primitives.CustomMetricArn.Type
    object CustomMetricDisplayName extends Subtype[String]
    type CustomMetricDisplayName =
      zio.aws.iot.model.primitives.CustomMetricDisplayName.Type
    object CustomerVersion extends Subtype[Int]
    type CustomerVersion = zio.aws.iot.model.primitives.CustomerVersion.Type
    object DataCollectionPercentage extends Subtype[Double]
    type DataCollectionPercentage =
      zio.aws.iot.model.primitives.DataCollectionPercentage.Type
    object DateType extends Subtype[Instant]
    type DateType = zio.aws.iot.model.primitives.DateType.Type
    object DayOfMonth extends Subtype[String]
    type DayOfMonth = zio.aws.iot.model.primitives.DayOfMonth.Type
    object DeleteAdditionalMetricsToRetain extends Subtype[Boolean]
    type DeleteAdditionalMetricsToRetain =
      zio.aws.iot.model.primitives.DeleteAdditionalMetricsToRetain.Type
    object DeleteAlertTargets extends Subtype[Boolean]
    type DeleteAlertTargets =
      zio.aws.iot.model.primitives.DeleteAlertTargets.Type
    object DeleteBehaviors extends Subtype[Boolean]
    type DeleteBehaviors = zio.aws.iot.model.primitives.DeleteBehaviors.Type
    object DeleteScheduledAudits extends Subtype[Boolean]
    type DeleteScheduledAudits =
      zio.aws.iot.model.primitives.DeleteScheduledAudits.Type
    object DeleteStream extends Subtype[Boolean]
    type DeleteStream = zio.aws.iot.model.primitives.DeleteStream.Type
    object DeliveryStreamName extends Subtype[String]
    type DeliveryStreamName =
      zio.aws.iot.model.primitives.DeliveryStreamName.Type
    object DeprecationDate extends Subtype[Instant]
    type DeprecationDate = zio.aws.iot.model.primitives.DeprecationDate.Type
    object Description extends Subtype[String]
    type Description = zio.aws.iot.model.primitives.Description.Type
    object DetailsKey extends Subtype[String]
    type DetailsKey = zio.aws.iot.model.primitives.DetailsKey.Type
    object DetailsValue extends Subtype[String]
    type DetailsValue = zio.aws.iot.model.primitives.DetailsValue.Type
    object DetectMitigationActionExecutionErrorCode extends Subtype[String]
    type DetectMitigationActionExecutionErrorCode =
      zio.aws.iot.model.primitives.DetectMitigationActionExecutionErrorCode.Type
    object DeviceDefenderThingName extends Subtype[String]
    type DeviceDefenderThingName =
      zio.aws.iot.model.primitives.DeviceDefenderThingName.Type
    object DimensionArn extends Subtype[String]
    type DimensionArn = zio.aws.iot.model.primitives.DimensionArn.Type
    object DimensionName extends Subtype[String]
    type DimensionName = zio.aws.iot.model.primitives.DimensionName.Type
    object DimensionStringValue extends Subtype[String]
    type DimensionStringValue =
      zio.aws.iot.model.primitives.DimensionStringValue.Type
    object DisableAllLogs extends Subtype[Boolean]
    type DisableAllLogs = zio.aws.iot.model.primitives.DisableAllLogs.Type
    object DisconnectReason extends Subtype[String]
    type DisconnectReason = zio.aws.iot.model.primitives.DisconnectReason.Type
    object DomainConfigurationArn extends Subtype[String]
    type DomainConfigurationArn =
      zio.aws.iot.model.primitives.DomainConfigurationArn.Type
    object DomainConfigurationName extends Subtype[String]
    type DomainConfigurationName =
      zio.aws.iot.model.primitives.DomainConfigurationName.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.iot.model.primitives.DomainName.Type
    object DurationSeconds extends Subtype[Int]
    type DurationSeconds = zio.aws.iot.model.primitives.DurationSeconds.Type
    object DynamoOperation extends Subtype[String]
    type DynamoOperation = zio.aws.iot.model.primitives.DynamoOperation.Type
    object ElasticsearchEndpoint extends Subtype[String]
    type ElasticsearchEndpoint =
      zio.aws.iot.model.primitives.ElasticsearchEndpoint.Type
    object ElasticsearchId extends Subtype[String]
    type ElasticsearchId = zio.aws.iot.model.primitives.ElasticsearchId.Type
    object ElasticsearchIndex extends Subtype[String]
    type ElasticsearchIndex =
      zio.aws.iot.model.primitives.ElasticsearchIndex.Type
    object ElasticsearchType extends Subtype[String]
    type ElasticsearchType = zio.aws.iot.model.primitives.ElasticsearchType.Type
    object EnableCachingForHttp extends Subtype[Boolean]
    type EnableCachingForHttp =
      zio.aws.iot.model.primitives.EnableCachingForHttp.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.iot.model.primitives.Enabled.Type
    object EndpointAddress extends Subtype[String]
    type EndpointAddress = zio.aws.iot.model.primitives.EndpointAddress.Type
    object EndpointType extends Subtype[String]
    type EndpointType = zio.aws.iot.model.primitives.EndpointType.Type
    object Environment extends Subtype[String]
    type Environment = zio.aws.iot.model.primitives.Environment.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.iot.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.iot.model.primitives.ErrorMessage.Type
    object EvaluationStatistic extends Subtype[String]
    type EvaluationStatistic =
      zio.aws.iot.model.primitives.EvaluationStatistic.Type
    object Example extends Subtype[String]
    type Example = zio.aws.iot.model.primitives.Example.Type
    object ExecutionNamePrefix extends Subtype[String]
    type ExecutionNamePrefix =
      zio.aws.iot.model.primitives.ExecutionNamePrefix.Type
    object ExecutionNumber extends Subtype[Long]
    type ExecutionNumber = zio.aws.iot.model.primitives.ExecutionNumber.Type
    object ExpectedVersion extends Subtype[Long]
    type ExpectedVersion = zio.aws.iot.model.primitives.ExpectedVersion.Type
    object ExpiresInSec extends Subtype[Long]
    type ExpiresInSec = zio.aws.iot.model.primitives.ExpiresInSec.Type
    object ExpiresInSeconds extends Subtype[Long]
    type ExpiresInSeconds = zio.aws.iot.model.primitives.ExpiresInSeconds.Type
    object FailedChecksCount extends Subtype[Int]
    type FailedChecksCount = zio.aws.iot.model.primitives.FailedChecksCount.Type
    object FailedFindingsCount extends Subtype[Long]
    type FailedFindingsCount =
      zio.aws.iot.model.primitives.FailedFindingsCount.Type
    object FailedThings extends Subtype[Int]
    type FailedThings = zio.aws.iot.model.primitives.FailedThings.Type
    object FieldName extends Subtype[String]
    type FieldName = zio.aws.iot.model.primitives.FieldName.Type
    object FileId extends Subtype[Int]
    type FileId = zio.aws.iot.model.primitives.FileId.Type
    object FileName extends Subtype[String]
    type FileName = zio.aws.iot.model.primitives.FileName.Type
    object FileType extends Subtype[Int]
    type FileType = zio.aws.iot.model.primitives.FileType.Type
    object FindingId extends Subtype[String]
    type FindingId = zio.aws.iot.model.primitives.FindingId.Type
    object FirehoseSeparator extends Subtype[String]
    type FirehoseSeparator = zio.aws.iot.model.primitives.FirehoseSeparator.Type
    object Flag extends Subtype[Boolean]
    type Flag = zio.aws.iot.model.primitives.Flag.Type
    object FleetMetricArn extends Subtype[String]
    type FleetMetricArn = zio.aws.iot.model.primitives.FleetMetricArn.Type
    object FleetMetricDescription extends Subtype[String]
    type FleetMetricDescription =
      zio.aws.iot.model.primitives.FleetMetricDescription.Type
    object FleetMetricName extends Subtype[String]
    type FleetMetricName = zio.aws.iot.model.primitives.FleetMetricName.Type
    object FleetMetricPeriod extends Subtype[Int]
    type FleetMetricPeriod = zio.aws.iot.model.primitives.FleetMetricPeriod.Type
    object ForceDelete extends Subtype[Boolean]
    type ForceDelete = zio.aws.iot.model.primitives.ForceDelete.Type
    object ForceDeleteAWSJob extends Subtype[Boolean]
    type ForceDeleteAWSJob = zio.aws.iot.model.primitives.ForceDeleteAWSJob.Type
    object ForceFlag extends Subtype[Boolean]
    type ForceFlag = zio.aws.iot.model.primitives.ForceFlag.Type
    object Forced extends Subtype[Boolean]
    type Forced = zio.aws.iot.model.primitives.Forced.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn = zio.aws.iot.model.primitives.FunctionArn.Type
    object GenerationId extends Subtype[String]
    type GenerationId = zio.aws.iot.model.primitives.GenerationId.Type
    object GenericLongValue extends Subtype[Long]
    type GenericLongValue = zio.aws.iot.model.primitives.GenericLongValue.Type
    object HashAlgorithm extends Subtype[String]
    type HashAlgorithm = zio.aws.iot.model.primitives.HashAlgorithm.Type
    object HashKeyField extends Subtype[String]
    type HashKeyField = zio.aws.iot.model.primitives.HashKeyField.Type
    object HashKeyValue extends Subtype[String]
    type HashKeyValue = zio.aws.iot.model.primitives.HashKeyValue.Type
    object HeaderKey extends Subtype[String]
    type HeaderKey = zio.aws.iot.model.primitives.HeaderKey.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue = zio.aws.iot.model.primitives.HeaderValue.Type
    object HttpHeaderName extends Subtype[String]
    type HttpHeaderName = zio.aws.iot.model.primitives.HttpHeaderName.Type
    object HttpHeaderValue extends Subtype[String]
    type HttpHeaderValue = zio.aws.iot.model.primitives.HttpHeaderValue.Type
    object HttpQueryString extends Subtype[String]
    type HttpQueryString = zio.aws.iot.model.primitives.HttpQueryString.Type
    object InProgressChecksCount extends Subtype[Int]
    type InProgressChecksCount =
      zio.aws.iot.model.primitives.InProgressChecksCount.Type
    object InProgressThings extends Subtype[Int]
    type InProgressThings = zio.aws.iot.model.primitives.InProgressThings.Type
    object InProgressTimeoutInMinutes extends Subtype[Long]
    type InProgressTimeoutInMinutes =
      zio.aws.iot.model.primitives.InProgressTimeoutInMinutes.Type
    object IncrementFactor extends Subtype[Double]
    type IncrementFactor = zio.aws.iot.model.primitives.IncrementFactor.Type
    object IndexName extends Subtype[String]
    type IndexName = zio.aws.iot.model.primitives.IndexName.Type
    object IndexSchema extends Subtype[String]
    type IndexSchema = zio.aws.iot.model.primitives.IndexSchema.Type
    object InlineDocument extends Subtype[String]
    type InlineDocument = zio.aws.iot.model.primitives.InlineDocument.Type
    object InputName extends Subtype[String]
    type InputName = zio.aws.iot.model.primitives.InputName.Type
    object IsAuthenticated extends Subtype[Boolean]
    type IsAuthenticated = zio.aws.iot.model.primitives.IsAuthenticated.Type
    object IsDefaultVersion extends Subtype[Boolean]
    type IsDefaultVersion = zio.aws.iot.model.primitives.IsDefaultVersion.Type
    object IsDisabled extends Subtype[Boolean]
    type IsDisabled = zio.aws.iot.model.primitives.IsDisabled.Type
    object IsSuppressed extends Subtype[Boolean]
    type IsSuppressed = zio.aws.iot.model.primitives.IsSuppressed.Type
    object JobArn extends Subtype[String]
    type JobArn = zio.aws.iot.model.primitives.JobArn.Type
    object JobDescription extends Subtype[String]
    type JobDescription = zio.aws.iot.model.primitives.JobDescription.Type
    object JobDocument extends Subtype[String]
    type JobDocument = zio.aws.iot.model.primitives.JobDocument.Type
    object JobDocumentSource extends Subtype[String]
    type JobDocumentSource = zio.aws.iot.model.primitives.JobDocumentSource.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.iot.model.primitives.JobId.Type
    object JobTemplateArn extends Subtype[String]
    type JobTemplateArn = zio.aws.iot.model.primitives.JobTemplateArn.Type
    object JobTemplateId extends Subtype[String]
    type JobTemplateId = zio.aws.iot.model.primitives.JobTemplateId.Type
    object JsonDocument extends Subtype[String]
    type JsonDocument = zio.aws.iot.model.primitives.JsonDocument.Type
    object Key extends Subtype[String]
    type Key = zio.aws.iot.model.primitives.Key.Type
    object KeyName extends Subtype[String]
    type KeyName = zio.aws.iot.model.primitives.KeyName.Type
    object KeyValue extends Subtype[String]
    type KeyValue = zio.aws.iot.model.primitives.KeyValue.Type
    object LaserMaxResults extends Subtype[Int]
    type LaserMaxResults = zio.aws.iot.model.primitives.LaserMaxResults.Type
    object LastModifiedDate extends Subtype[Instant]
    type LastModifiedDate = zio.aws.iot.model.primitives.LastModifiedDate.Type
    object LastUpdatedAtDate extends Subtype[Instant]
    type LastUpdatedAtDate = zio.aws.iot.model.primitives.LastUpdatedAtDate.Type
    object ListSuppressedAlerts extends Subtype[Boolean]
    type ListSuppressedAlerts =
      zio.aws.iot.model.primitives.ListSuppressedAlerts.Type
    object ListSuppressedFindings extends Subtype[Boolean]
    type ListSuppressedFindings =
      zio.aws.iot.model.primitives.ListSuppressedFindings.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName = zio.aws.iot.model.primitives.LogGroupName.Type
    object LogTargetName extends Subtype[String]
    type LogTargetName = zio.aws.iot.model.primitives.LogTargetName.Type
    object ManagedJobTemplateName extends Subtype[String]
    type ManagedJobTemplateName =
      zio.aws.iot.model.primitives.ManagedJobTemplateName.Type
    object ManagedTemplateVersion extends Subtype[String]
    type ManagedTemplateVersion =
      zio.aws.iot.model.primitives.ManagedTemplateVersion.Type
    object Marker extends Subtype[String]
    type Marker = zio.aws.iot.model.primitives.Marker.Type
    object MaxBuckets extends Subtype[Int]
    type MaxBuckets = zio.aws.iot.model.primitives.MaxBuckets.Type
    object MaxJobExecutionsPerMin extends Subtype[Int]
    type MaxJobExecutionsPerMin =
      zio.aws.iot.model.primitives.MaxJobExecutionsPerMin.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iot.model.primitives.MaxResults.Type
    object Maximum extends Subtype[Double]
    type Maximum = zio.aws.iot.model.primitives.Maximum.Type
    object MaximumPerMinute extends Subtype[Int]
    type MaximumPerMinute = zio.aws.iot.model.primitives.MaximumPerMinute.Type
    object Message extends Subtype[String]
    type Message = zio.aws.iot.model.primitives.Message.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.iot.model.primitives.MessageId.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.iot.model.primitives.MetricName.Type
    object Minimum extends Subtype[Double]
    type Minimum = zio.aws.iot.model.primitives.Minimum.Type
    object MinimumNumberOfExecutedThings extends Subtype[Int]
    type MinimumNumberOfExecutedThings =
      zio.aws.iot.model.primitives.MinimumNumberOfExecutedThings.Type
    object MissingContextValue extends Subtype[String]
    type MissingContextValue =
      zio.aws.iot.model.primitives.MissingContextValue.Type
    object MitigationActionArn extends Subtype[String]
    type MitigationActionArn =
      zio.aws.iot.model.primitives.MitigationActionArn.Type
    object MitigationActionId extends Subtype[String]
    type MitigationActionId =
      zio.aws.iot.model.primitives.MitigationActionId.Type
    object MitigationActionName extends Subtype[String]
    type MitigationActionName =
      zio.aws.iot.model.primitives.MitigationActionName.Type
    object MitigationActionsTaskId extends Subtype[String]
    type MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId.Type
    object MqttClientId extends Subtype[String]
    type MqttClientId = zio.aws.iot.model.primitives.MqttClientId.Type
    object MqttPassword extends Subtype[Chunk[Byte]]
    type MqttPassword = zio.aws.iot.model.primitives.MqttPassword.Type
    object MqttUsername extends Subtype[String]
    type MqttUsername = zio.aws.iot.model.primitives.MqttUsername.Type
    object NamespaceId extends Subtype[String]
    type NamespaceId = zio.aws.iot.model.primitives.NamespaceId.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iot.model.primitives.NextToken.Type
    object NonCompliantChecksCount extends Subtype[Int]
    type NonCompliantChecksCount =
      zio.aws.iot.model.primitives.NonCompliantChecksCount.Type
    object NonCompliantResourcesCount extends Subtype[Long]
    type NonCompliantResourcesCount =
      zio.aws.iot.model.primitives.NonCompliantResourcesCount.Type
    type NullableBoolean = Boolean
    object Number extends Subtype[Double]
    type Number = zio.aws.iot.model.primitives.Number.Type
    object NumberOfRetries extends Subtype[Int]
    type NumberOfRetries = zio.aws.iot.model.primitives.NumberOfRetries.Type
    object NumberOfThings extends Subtype[Int]
    type NumberOfThings = zio.aws.iot.model.primitives.NumberOfThings.Type
    object OTAUpdateArn extends Subtype[String]
    type OTAUpdateArn = zio.aws.iot.model.primitives.OTAUpdateArn.Type
    object OTAUpdateDescription extends Subtype[String]
    type OTAUpdateDescription =
      zio.aws.iot.model.primitives.OTAUpdateDescription.Type
    object OTAUpdateErrorMessage extends Subtype[String]
    type OTAUpdateErrorMessage =
      zio.aws.iot.model.primitives.OTAUpdateErrorMessage.Type
    object OTAUpdateFileVersion extends Subtype[String]
    type OTAUpdateFileVersion =
      zio.aws.iot.model.primitives.OTAUpdateFileVersion.Type
    object OTAUpdateId extends Subtype[String]
    type OTAUpdateId = zio.aws.iot.model.primitives.OTAUpdateId.Type
    object Optional extends Subtype[Boolean]
    type Optional = zio.aws.iot.model.primitives.Optional.Type
    object OptionalVersion extends Subtype[Long]
    type OptionalVersion = zio.aws.iot.model.primitives.OptionalVersion.Type
    object OverrideDynamicGroups extends Subtype[Boolean]
    type OverrideDynamicGroups =
      zio.aws.iot.model.primitives.OverrideDynamicGroups.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.iot.model.primitives.PageSize.Type
    object Parameter extends Subtype[String]
    type Parameter = zio.aws.iot.model.primitives.Parameter.Type
    object ParameterKey extends Subtype[String]
    type ParameterKey = zio.aws.iot.model.primitives.ParameterKey.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue = zio.aws.iot.model.primitives.ParameterValue.Type
    object PartitionKey extends Subtype[String]
    type PartitionKey = zio.aws.iot.model.primitives.PartitionKey.Type
    object PayloadField extends Subtype[String]
    type PayloadField = zio.aws.iot.model.primitives.PayloadField.Type
    object PayloadVersion extends Subtype[String]
    type PayloadVersion = zio.aws.iot.model.primitives.PayloadVersion.Type
    object Percent extends Subtype[Double]
    type Percent = zio.aws.iot.model.primitives.Percent.Type
    object PercentValue extends Subtype[Double]
    type PercentValue = zio.aws.iot.model.primitives.PercentValue.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.iot.model.primitives.Percentage.Type
    object Platform extends Subtype[String]
    type Platform = zio.aws.iot.model.primitives.Platform.Type
    object PolicyArn extends Subtype[String]
    type PolicyArn = zio.aws.iot.model.primitives.PolicyArn.Type
    object PolicyDocument extends Subtype[String]
    type PolicyDocument = zio.aws.iot.model.primitives.PolicyDocument.Type
    object PolicyName extends Subtype[String]
    type PolicyName = zio.aws.iot.model.primitives.PolicyName.Type
    object PolicyTarget extends Subtype[String]
    type PolicyTarget = zio.aws.iot.model.primitives.PolicyTarget.Type
    object PolicyVersionId extends Subtype[String]
    type PolicyVersionId = zio.aws.iot.model.primitives.PolicyVersionId.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.iot.model.primitives.Port.Type
    object Prefix extends Subtype[String]
    type Prefix = zio.aws.iot.model.primitives.Prefix.Type
    object PrimitiveBoolean extends Subtype[Boolean]
    type PrimitiveBoolean = zio.aws.iot.model.primitives.PrimitiveBoolean.Type
    object Principal extends Subtype[String]
    type Principal = zio.aws.iot.model.primitives.Principal.Type
    object PrincipalArn extends Subtype[String]
    type PrincipalArn = zio.aws.iot.model.primitives.PrincipalArn.Type
    object PrincipalId extends Subtype[String]
    type PrincipalId = zio.aws.iot.model.primitives.PrincipalId.Type
    object PrivateKey extends Subtype[String]
    type PrivateKey = zio.aws.iot.model.primitives.PrivateKey.Type
    object ProcessingTargetName extends Subtype[String]
    type ProcessingTargetName =
      zio.aws.iot.model.primitives.ProcessingTargetName.Type
    object PublicKey extends Subtype[String]
    type PublicKey = zio.aws.iot.model.primitives.PublicKey.Type
    object Qos extends Subtype[Int]
    type Qos = zio.aws.iot.model.primitives.Qos.Type
    object QueryMaxResults extends Subtype[Int]
    type QueryMaxResults = zio.aws.iot.model.primitives.QueryMaxResults.Type
    object QueryString extends Subtype[String]
    type QueryString = zio.aws.iot.model.primitives.QueryString.Type
    object QueryVersion extends Subtype[String]
    type QueryVersion = zio.aws.iot.model.primitives.QueryVersion.Type
    object QueueUrl extends Subtype[String]
    type QueueUrl = zio.aws.iot.model.primitives.QueueUrl.Type
    object QueuedThings extends Subtype[Int]
    type QueuedThings = zio.aws.iot.model.primitives.QueuedThings.Type
    object RangeKeyField extends Subtype[String]
    type RangeKeyField = zio.aws.iot.model.primitives.RangeKeyField.Type
    object RangeKeyValue extends Subtype[String]
    type RangeKeyValue = zio.aws.iot.model.primitives.RangeKeyValue.Type
    object ReasonCode extends Subtype[String]
    type ReasonCode = zio.aws.iot.model.primitives.ReasonCode.Type
    object ReasonForNonCompliance extends Subtype[String]
    type ReasonForNonCompliance =
      zio.aws.iot.model.primitives.ReasonForNonCompliance.Type
    object ReasonForNonComplianceCode extends Subtype[String]
    type ReasonForNonComplianceCode =
      zio.aws.iot.model.primitives.ReasonForNonComplianceCode.Type
    object Recursive extends Subtype[Boolean]
    type Recursive = zio.aws.iot.model.primitives.Recursive.Type
    object RecursiveWithoutDefault extends Subtype[Boolean]
    type RecursiveWithoutDefault =
      zio.aws.iot.model.primitives.RecursiveWithoutDefault.Type
    object Regex extends Subtype[String]
    type Regex = zio.aws.iot.model.primitives.Regex.Type
    object RegistrationCode extends Subtype[String]
    type RegistrationCode = zio.aws.iot.model.primitives.RegistrationCode.Type
    object RegistryMaxResults extends Subtype[Int]
    type RegistryMaxResults =
      zio.aws.iot.model.primitives.RegistryMaxResults.Type
    object RegistryS3BucketName extends Subtype[String]
    type RegistryS3BucketName =
      zio.aws.iot.model.primitives.RegistryS3BucketName.Type
    object RegistryS3KeyName extends Subtype[String]
    type RegistryS3KeyName = zio.aws.iot.model.primitives.RegistryS3KeyName.Type
    object RejectedThings extends Subtype[Int]
    type RejectedThings = zio.aws.iot.model.primitives.RejectedThings.Type
    object RemoveAuthorizerConfig extends Subtype[Boolean]
    type RemoveAuthorizerConfig =
      zio.aws.iot.model.primitives.RemoveAuthorizerConfig.Type
    object RemoveAutoRegistration extends Subtype[Boolean]
    type RemoveAutoRegistration =
      zio.aws.iot.model.primitives.RemoveAutoRegistration.Type
    object RemoveHook extends Subtype[Boolean]
    type RemoveHook = zio.aws.iot.model.primitives.RemoveHook.Type
    object RemoveThingType extends Subtype[Boolean]
    type RemoveThingType = zio.aws.iot.model.primitives.RemoveThingType.Type
    object RemovedThings extends Subtype[Int]
    type RemovedThings = zio.aws.iot.model.primitives.RemovedThings.Type
    object ReservedDomainConfigurationName extends Subtype[String]
    type ReservedDomainConfigurationName =
      zio.aws.iot.model.primitives.ReservedDomainConfigurationName.Type
    object Resource extends Subtype[String]
    type Resource = zio.aws.iot.model.primitives.Resource.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.iot.model.primitives.ResourceArn.Type
    object ResourceLogicalId extends Subtype[String]
    type ResourceLogicalId = zio.aws.iot.model.primitives.ResourceLogicalId.Type
    object RetryAttempt extends Subtype[Int]
    type RetryAttempt = zio.aws.iot.model.primitives.RetryAttempt.Type
    object RoleAlias extends Subtype[String]
    type RoleAlias = zio.aws.iot.model.primitives.RoleAlias.Type
    object RoleAliasArn extends Subtype[String]
    type RoleAliasArn = zio.aws.iot.model.primitives.RoleAliasArn.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.iot.model.primitives.RoleArn.Type
    object RolloutRatePerMinute extends Subtype[Int]
    type RolloutRatePerMinute =
      zio.aws.iot.model.primitives.RolloutRatePerMinute.Type
    object RuleArn extends Subtype[String]
    type RuleArn = zio.aws.iot.model.primitives.RuleArn.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.iot.model.primitives.RuleName.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.iot.model.primitives.S3Bucket.Type
    object S3FileUrl extends Subtype[String]
    type S3FileUrl = zio.aws.iot.model.primitives.S3FileUrl.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.iot.model.primitives.S3Key.Type
    object S3Version extends Subtype[String]
    type S3Version = zio.aws.iot.model.primitives.S3Version.Type
    object SQL extends Subtype[String]
    type SQL = zio.aws.iot.model.primitives.SQL.Type
    object SalesforceEndpoint extends Subtype[String]
    type SalesforceEndpoint =
      zio.aws.iot.model.primitives.SalesforceEndpoint.Type
    object SalesforceToken extends Subtype[String]
    type SalesforceToken = zio.aws.iot.model.primitives.SalesforceToken.Type
    object ScheduledAuditArn extends Subtype[String]
    type ScheduledAuditArn = zio.aws.iot.model.primitives.ScheduledAuditArn.Type
    object ScheduledAuditName extends Subtype[String]
    type ScheduledAuditName =
      zio.aws.iot.model.primitives.ScheduledAuditName.Type
    object Seconds extends Subtype[Int]
    type Seconds = zio.aws.iot.model.primitives.Seconds.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.iot.model.primitives.SecurityGroupId.Type
    object SecurityProfileArn extends Subtype[String]
    type SecurityProfileArn =
      zio.aws.iot.model.primitives.SecurityProfileArn.Type
    object SecurityProfileDescription extends Subtype[String]
    type SecurityProfileDescription =
      zio.aws.iot.model.primitives.SecurityProfileDescription.Type
    object SecurityProfileName extends Subtype[String]
    type SecurityProfileName =
      zio.aws.iot.model.primitives.SecurityProfileName.Type
    object SecurityProfileTargetArn extends Subtype[String]
    type SecurityProfileTargetArn =
      zio.aws.iot.model.primitives.SecurityProfileTargetArn.Type
    object ServerCertificateStatusDetail extends Subtype[String]
    type ServerCertificateStatusDetail =
      zio.aws.iot.model.primitives.ServerCertificateStatusDetail.Type
    object ServerName extends Subtype[String]
    type ServerName = zio.aws.iot.model.primitives.ServerName.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.iot.model.primitives.ServiceName.Type
    object SetAsActive extends Subtype[Boolean]
    type SetAsActive = zio.aws.iot.model.primitives.SetAsActive.Type
    object SetAsActiveFlag extends Subtype[Boolean]
    type SetAsActiveFlag = zio.aws.iot.model.primitives.SetAsActiveFlag.Type
    object SetAsDefault extends Subtype[Boolean]
    type SetAsDefault = zio.aws.iot.model.primitives.SetAsDefault.Type
    object ShadowName extends Subtype[String]
    type ShadowName = zio.aws.iot.model.primitives.ShadowName.Type
    object Signature extends Subtype[Chunk[Byte]]
    type Signature = zio.aws.iot.model.primitives.Signature.Type
    object SignatureAlgorithm extends Subtype[String]
    type SignatureAlgorithm =
      zio.aws.iot.model.primitives.SignatureAlgorithm.Type
    object SigningJobId extends Subtype[String]
    type SigningJobId = zio.aws.iot.model.primitives.SigningJobId.Type
    object SigningProfileName extends Subtype[String]
    type SigningProfileName =
      zio.aws.iot.model.primitives.SigningProfileName.Type
    object SigningRegion extends Subtype[String]
    type SigningRegion = zio.aws.iot.model.primitives.SigningRegion.Type
    object SkippedFindingsCount extends Subtype[Long]
    type SkippedFindingsCount =
      zio.aws.iot.model.primitives.SkippedFindingsCount.Type
    object SkyfallMaxResults extends Subtype[Int]
    type SkyfallMaxResults = zio.aws.iot.model.primitives.SkyfallMaxResults.Type
    object SnsTopicArn extends Subtype[String]
    type SnsTopicArn = zio.aws.iot.model.primitives.SnsTopicArn.Type
    object StateMachineName extends Subtype[String]
    type StateMachineName = zio.aws.iot.model.primitives.StateMachineName.Type
    object StateReason extends Subtype[String]
    type StateReason = zio.aws.iot.model.primitives.StateReason.Type
    object StateValue extends Subtype[String]
    type StateValue = zio.aws.iot.model.primitives.StateValue.Type
    object StdDeviation extends Subtype[Double]
    type StdDeviation = zio.aws.iot.model.primitives.StdDeviation.Type
    object StreamArn extends Subtype[String]
    type StreamArn = zio.aws.iot.model.primitives.StreamArn.Type
    object StreamDescription extends Subtype[String]
    type StreamDescription = zio.aws.iot.model.primitives.StreamDescription.Type
    object StreamId extends Subtype[String]
    type StreamId = zio.aws.iot.model.primitives.StreamId.Type
    object StreamName extends Subtype[String]
    type StreamName = zio.aws.iot.model.primitives.StreamName.Type
    object StreamVersion extends Subtype[Int]
    type StreamVersion = zio.aws.iot.model.primitives.StreamVersion.Type
    object StringValue extends Subtype[String]
    type StringValue = zio.aws.iot.model.primitives.StringValue.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.iot.model.primitives.SubnetId.Type
    object SucceededFindingsCount extends Subtype[Long]
    type SucceededFindingsCount =
      zio.aws.iot.model.primitives.SucceededFindingsCount.Type
    object SucceededThings extends Subtype[Int]
    type SucceededThings = zio.aws.iot.model.primitives.SucceededThings.Type
    object Sum extends Subtype[Double]
    type Sum = zio.aws.iot.model.primitives.Sum.Type
    object SumOfSquares extends Subtype[Double]
    type SumOfSquares = zio.aws.iot.model.primitives.SumOfSquares.Type
    object SuppressAlerts extends Subtype[Boolean]
    type SuppressAlerts = zio.aws.iot.model.primitives.SuppressAlerts.Type
    object SuppressIndefinitely extends Subtype[Boolean]
    type SuppressIndefinitely =
      zio.aws.iot.model.primitives.SuppressIndefinitely.Type
    object SuppressedNonCompliantResourcesCount extends Subtype[Long]
    type SuppressedNonCompliantResourcesCount =
      zio.aws.iot.model.primitives.SuppressedNonCompliantResourcesCount.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.iot.model.primitives.TableName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iot.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iot.model.primitives.TagValue.Type
    object Target extends Subtype[String]
    type Target = zio.aws.iot.model.primitives.Target.Type
    object TargetArn extends Subtype[String]
    type TargetArn = zio.aws.iot.model.primitives.TargetArn.Type
    object TaskId extends Subtype[String]
    type TaskId = zio.aws.iot.model.primitives.TaskId.Type
    object TemplateArn extends Subtype[String]
    type TemplateArn = zio.aws.iot.model.primitives.TemplateArn.Type
    object TemplateBody extends Subtype[String]
    type TemplateBody = zio.aws.iot.model.primitives.TemplateBody.Type
    object TemplateDescription extends Subtype[String]
    type TemplateDescription =
      zio.aws.iot.model.primitives.TemplateDescription.Type
    object TemplateName extends Subtype[String]
    type TemplateName = zio.aws.iot.model.primitives.TemplateName.Type
    object TemplateVersionId extends Subtype[Int]
    type TemplateVersionId = zio.aws.iot.model.primitives.TemplateVersionId.Type
    object ThingArn extends Subtype[String]
    type ThingArn = zio.aws.iot.model.primitives.ThingArn.Type
    object ThingGroupArn extends Subtype[String]
    type ThingGroupArn = zio.aws.iot.model.primitives.ThingGroupArn.Type
    object ThingGroupDescription extends Subtype[String]
    type ThingGroupDescription =
      zio.aws.iot.model.primitives.ThingGroupDescription.Type
    object ThingGroupId extends Subtype[String]
    type ThingGroupId = zio.aws.iot.model.primitives.ThingGroupId.Type
    object ThingGroupName extends Subtype[String]
    type ThingGroupName = zio.aws.iot.model.primitives.ThingGroupName.Type
    object ThingId extends Subtype[String]
    type ThingId = zio.aws.iot.model.primitives.ThingId.Type
    object ThingName extends Subtype[String]
    type ThingName = zio.aws.iot.model.primitives.ThingName.Type
    object ThingTypeArn extends Subtype[String]
    type ThingTypeArn = zio.aws.iot.model.primitives.ThingTypeArn.Type
    object ThingTypeDescription extends Subtype[String]
    type ThingTypeDescription =
      zio.aws.iot.model.primitives.ThingTypeDescription.Type
    object ThingTypeId extends Subtype[String]
    type ThingTypeId = zio.aws.iot.model.primitives.ThingTypeId.Type
    object ThingTypeName extends Subtype[String]
    type ThingTypeName = zio.aws.iot.model.primitives.ThingTypeName.Type
    object TimedOutThings extends Subtype[Int]
    type TimedOutThings = zio.aws.iot.model.primitives.TimedOutThings.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iot.model.primitives.Timestamp.Type
    object TimestreamDatabaseName extends Subtype[String]
    type TimestreamDatabaseName =
      zio.aws.iot.model.primitives.TimestreamDatabaseName.Type
    object TimestreamDimensionName extends Subtype[String]
    type TimestreamDimensionName =
      zio.aws.iot.model.primitives.TimestreamDimensionName.Type
    object TimestreamDimensionValue extends Subtype[String]
    type TimestreamDimensionValue =
      zio.aws.iot.model.primitives.TimestreamDimensionValue.Type
    object TimestreamTableName extends Subtype[String]
    type TimestreamTableName =
      zio.aws.iot.model.primitives.TimestreamTableName.Type
    object TimestreamTimestampUnit extends Subtype[String]
    type TimestreamTimestampUnit =
      zio.aws.iot.model.primitives.TimestreamTimestampUnit.Type
    object TimestreamTimestampValue extends Subtype[String]
    type TimestreamTimestampValue =
      zio.aws.iot.model.primitives.TimestreamTimestampValue.Type
    object TinyMaxResults extends Subtype[Int]
    type TinyMaxResults = zio.aws.iot.model.primitives.TinyMaxResults.Type
    object Token extends Subtype[String]
    type Token = zio.aws.iot.model.primitives.Token.Type
    object TokenKeyName extends Subtype[String]
    type TokenKeyName = zio.aws.iot.model.primitives.TokenKeyName.Type
    object TokenSignature extends Subtype[String]
    type TokenSignature = zio.aws.iot.model.primitives.TokenSignature.Type
    object Topic extends Subtype[String]
    type Topic = zio.aws.iot.model.primitives.Topic.Type
    object TopicPattern extends Subtype[String]
    type TopicPattern = zio.aws.iot.model.primitives.TopicPattern.Type
    object TopicRuleDestinationMaxResults extends Subtype[Int]
    type TopicRuleDestinationMaxResults =
      zio.aws.iot.model.primitives.TopicRuleDestinationMaxResults.Type
    object TopicRuleMaxResults extends Subtype[Int]
    type TopicRuleMaxResults =
      zio.aws.iot.model.primitives.TopicRuleMaxResults.Type
    object TotalChecksCount extends Subtype[Int]
    type TotalChecksCount = zio.aws.iot.model.primitives.TotalChecksCount.Type
    object TotalFindingsCount extends Subtype[Long]
    type TotalFindingsCount =
      zio.aws.iot.model.primitives.TotalFindingsCount.Type
    object TotalResourcesCount extends Subtype[Long]
    type TotalResourcesCount =
      zio.aws.iot.model.primitives.TotalResourcesCount.Type
    object UndoDeprecate extends Subtype[Boolean]
    type UndoDeprecate = zio.aws.iot.model.primitives.UndoDeprecate.Type
    object UnsignedLong extends Subtype[Long]
    type UnsignedLong = zio.aws.iot.model.primitives.UnsignedLong.Type
    object Url extends Subtype[String]
    type Url = zio.aws.iot.model.primitives.Url.Type
    object UseBase64 extends Subtype[Boolean]
    type UseBase64 = zio.aws.iot.model.primitives.UseBase64.Type
    object UsePrefixAttributeValue extends Subtype[Boolean]
    type UsePrefixAttributeValue =
      zio.aws.iot.model.primitives.UsePrefixAttributeValue.Type
    object Valid extends Subtype[Boolean]
    type Valid = zio.aws.iot.model.primitives.Valid.Type
    object Value extends Subtype[String]
    type Value = zio.aws.iot.model.primitives.Value.Type
    object Variance extends Subtype[Double]
    type Variance = zio.aws.iot.model.primitives.Variance.Type
    object VerificationStateDescription extends Subtype[String]
    type VerificationStateDescription =
      zio.aws.iot.model.primitives.VerificationStateDescription.Type
    object Version extends Subtype[Long]
    type Version = zio.aws.iot.model.primitives.Version.Type
    object VersionNumber extends Subtype[Long]
    type VersionNumber = zio.aws.iot.model.primitives.VersionNumber.Type
    object ViolationId extends Subtype[String]
    type ViolationId = zio.aws.iot.model.primitives.ViolationId.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.iot.model.primitives.VpcId.Type
    object WaitingForDataCollectionChecksCount extends Subtype[Int]
    type WaitingForDataCollectionChecksCount =
      zio.aws.iot.model.primitives.WaitingForDataCollectionChecksCount.Type
  }
  type AbortCriteriaList = List[zio.aws.iot.model.AbortCriteria]
  type ActionList = List[zio.aws.iot.model.Action]
  type ActiveViolations = List[zio.aws.iot.model.ActiveViolation]
  type AdditionalMetricsToRetainList = List[BehaviorMetric]
  type AdditionalMetricsToRetainV2List = List[zio.aws.iot.model.MetricToRetain]
  type AdditionalParameterMap = Map[AttributeKey, Value]
  type AggregationTypeValues = List[AggregationTypeValue]
  type AlertTargets =
    Map[zio.aws.iot.model.AlertTargetType, zio.aws.iot.model.AlertTarget]
  type AssetPropertyValueList = List[zio.aws.iot.model.AssetPropertyValue]
  type Attributes = Map[AttributeName, AttributeValue]
  type AttributesMap = Map[AttributeKey, Value]
  type AuditCheckConfigurations =
    Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration]
  type AuditCheckToActionsMapping =
    Map[AuditCheckName, Iterable[MitigationActionName]]
  type AuditCheckToReasonCodeFilter =
    Map[AuditCheckName, Iterable[ReasonForNonComplianceCode]]
  type AuditDetails = Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails]
  type AuditFindings = List[zio.aws.iot.model.AuditFinding]
  type AuditMitigationActionExecutionMetadataList =
    List[zio.aws.iot.model.AuditMitigationActionExecutionMetadata]
  type AuditMitigationActionsTaskMetadataList =
    List[zio.aws.iot.model.AuditMitigationActionsTaskMetadata]
  type AuditMitigationActionsTaskStatistics =
    Map[AuditCheckName, zio.aws.iot.model.TaskStatisticsForAuditCheck]
  type AuditNotificationTargetConfigurations = Map[
    zio.aws.iot.model.AuditNotificationType,
    zio.aws.iot.model.AuditNotificationTarget
  ]
  type AuditSuppressionList = List[zio.aws.iot.model.AuditSuppression]
  type AuditTaskMetadataList = List[zio.aws.iot.model.AuditTaskMetadata]
  type AuthInfos = List[zio.aws.iot.model.AuthInfo]
  type AuthResults = List[zio.aws.iot.model.AuthResult]
  type Authorizers = List[zio.aws.iot.model.AuthorizerSummary]
  type AwsJobAbortCriteriaList = List[zio.aws.iot.model.AwsJobAbortCriteria]
  type BehaviorModelTrainingSummaries =
    List[zio.aws.iot.model.BehaviorModelTrainingSummary]
  type Behaviors = List[zio.aws.iot.model.Behavior]
  type BillingGroupNameAndArnList = List[zio.aws.iot.model.GroupNameAndArn]
  type Buckets = List[zio.aws.iot.model.Bucket]
  type CACertificates = List[zio.aws.iot.model.CACertificate]
  type Certificates = List[zio.aws.iot.model.Certificate]
  type Cidrs = List[Cidr]
  type ClientProperties = Map[String, String]
  type DetailsMap = Map[DetailsKey, DetailsValue]
  type DetectMitigationActionExecutionList =
    List[zio.aws.iot.model.DetectMitigationActionExecution]
  type DetectMitigationActionsTaskSummaryList =
    List[zio.aws.iot.model.DetectMitigationActionsTaskSummary]
  type DetectMitigationActionsToExecuteList = List[MitigationActionName]
  type DimensionNames = List[DimensionName]
  type DimensionStringValues = List[DimensionStringValue]
  type DocumentParameters = List[zio.aws.iot.model.DocumentParameter]
  type DomainConfigurations = List[zio.aws.iot.model.DomainConfigurationSummary]
  type EffectivePolicies = List[zio.aws.iot.model.EffectivePolicy]
  type Environments = List[Environment]
  type EventConfigurations =
    Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration]
  type Fields = List[zio.aws.iot.model.Field]
  type FindingIds = List[FindingId]
  type FleetMetricNameAndArnList = List[zio.aws.iot.model.FleetMetricNameAndArn]
  type HeaderList = List[zio.aws.iot.model.HttpActionHeader]
  type HttpHeaders = Map[HttpHeaderName, HttpHeaderValue]
  type IndexNamesList = List[IndexName]
  type JobExecutionSummaryForJobList =
    List[zio.aws.iot.model.JobExecutionSummaryForJob]
  type JobExecutionSummaryForThingList =
    List[zio.aws.iot.model.JobExecutionSummaryForThing]
  type JobSummaryList = List[zio.aws.iot.model.JobSummary]
  type JobTargets = List[TargetArn]
  type JobTemplateSummaryList = List[zio.aws.iot.model.JobTemplateSummary]
  type LogTargetConfigurations = List[zio.aws.iot.model.LogTargetConfiguration]
  type ManagedJobTemplatesSummaryList =
    List[zio.aws.iot.model.ManagedJobTemplateSummary]
  type MetricDatumList = List[zio.aws.iot.model.MetricDatum]
  type MetricNames = List[MetricName]
  type MissingContextValues = List[MissingContextValue]
  type MitigationActionIdentifierList =
    List[zio.aws.iot.model.MitigationActionIdentifier]
  type MitigationActionList = List[zio.aws.iot.model.MitigationAction]
  type MitigationActionNameList = List[MitigationActionName]
  type NamedShadowNamesFilter = List[ShadowName]
  type NumberList = List[Number]
  type OTAUpdateFiles = List[zio.aws.iot.model.OTAUpdateFile]
  type OTAUpdatesSummary = List[zio.aws.iot.model.OTAUpdateSummary]
  type OutgoingCertificates = List[zio.aws.iot.model.OutgoingCertificate]
  type ParameterMap = Map[ParameterKey, ParameterValue]
  type Parameters = Map[Parameter, Value]
  type PercentList = List[Percent]
  type Percentiles = List[zio.aws.iot.model.PercentPair]
  type Policies = List[zio.aws.iot.model.Policy]
  type PolicyDocuments = List[PolicyDocument]
  type PolicyNames = List[PolicyName]
  type PolicyTargets = List[PolicyTarget]
  type PolicyVersions = List[zio.aws.iot.model.PolicyVersion]
  type Ports = List[Port]
  type Principals = List[PrincipalArn]
  type ProcessingTargetNameList = List[ProcessingTargetName]
  type Protocols = List[zio.aws.iot.model.Protocol]
  type ProvisioningTemplateListing =
    List[zio.aws.iot.model.ProvisioningTemplateSummary]
  type ProvisioningTemplateVersionListing =
    List[zio.aws.iot.model.ProvisioningTemplateVersionSummary]
  type PublicKeyMap = Map[KeyName, KeyValue]
  type PutAssetPropertyValueEntryList =
    List[zio.aws.iot.model.PutAssetPropertyValueEntry]
  type ReasonForNonComplianceCodes = List[ReasonForNonComplianceCode]
  type RelatedResources = List[zio.aws.iot.model.RelatedResource]
  type ResourceArns = Map[ResourceLogicalId, ResourceArn]
  type Resources = List[Resource]
  type RetryCriteriaList = List[zio.aws.iot.model.RetryCriteria]
  type RoleAliases = List[RoleAlias]
  type S3FileUrlList = List[S3FileUrl]
  type ScheduledAuditMetadataList =
    List[zio.aws.iot.model.ScheduledAuditMetadata]
  type SearchableAttributes = List[AttributeName]
  type SecurityGroupList = List[SecurityGroupId]
  type SecurityProfileIdentifiers =
    List[zio.aws.iot.model.SecurityProfileIdentifier]
  type SecurityProfileTargetMappings =
    List[zio.aws.iot.model.SecurityProfileTargetMapping]
  type SecurityProfileTargets = List[zio.aws.iot.model.SecurityProfileTarget]
  type ServerCertificateArns = List[AcmCertificateArn]
  type ServerCertificates = List[zio.aws.iot.model.ServerCertificateSummary]
  type StreamFiles = List[zio.aws.iot.model.StreamFile]
  type StreamsSummary = List[zio.aws.iot.model.StreamSummary]
  type StringList = List[StringValue]
  type StringMap = Map[String, String]
  type SubnetIdList = List[SubnetId]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.iot.model.Tag]
  type TargetAuditCheckNames = List[AuditCheckName]
  type TargetViolationIdsForDetectMitigationActions = List[ViolationId]
  type Targets = List[Target]
  type TaskIdList = List[TaskId]
  type ThingAttributeList = List[zio.aws.iot.model.ThingAttribute]
  type ThingDocumentList = List[zio.aws.iot.model.ThingDocument]
  type ThingGroupDocumentList = List[zio.aws.iot.model.ThingGroupDocument]
  type ThingGroupList = List[ThingGroupName]
  type ThingGroupNameAndArnList = List[zio.aws.iot.model.GroupNameAndArn]
  type ThingGroupNameList = List[ThingGroupName]
  type ThingGroupNames = List[ThingGroupName]
  type ThingNameList = List[ThingName]
  type ThingTypeList = List[zio.aws.iot.model.ThingTypeDefinition]
  type TimestreamDimensionList = List[zio.aws.iot.model.TimestreamDimension]
  type TopicRuleDestinationSummaries =
    List[zio.aws.iot.model.TopicRuleDestinationSummary]
  type TopicRuleList = List[zio.aws.iot.model.TopicRuleListItem]
  type ValidationErrors = List[zio.aws.iot.model.ValidationError]
  type ViolationEvents = List[zio.aws.iot.model.ViolationEvent]
}
