package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Action(
    dynamoDB: Optional[zio.aws.iot.model.DynamoDBAction] = Optional.Absent,
    dynamoDBv2: Optional[zio.aws.iot.model.DynamoDBv2Action] = Optional.Absent,
    lambda: Optional[zio.aws.iot.model.LambdaAction] = Optional.Absent,
    sns: Optional[zio.aws.iot.model.SnsAction] = Optional.Absent,
    sqs: Optional[zio.aws.iot.model.SqsAction] = Optional.Absent,
    kinesis: Optional[zio.aws.iot.model.KinesisAction] = Optional.Absent,
    republish: Optional[zio.aws.iot.model.RepublishAction] = Optional.Absent,
    s3: Optional[zio.aws.iot.model.S3Action] = Optional.Absent,
    firehose: Optional[zio.aws.iot.model.FirehoseAction] = Optional.Absent,
    cloudwatchMetric: Optional[zio.aws.iot.model.CloudwatchMetricAction] =
      Optional.Absent,
    cloudwatchAlarm: Optional[zio.aws.iot.model.CloudwatchAlarmAction] =
      Optional.Absent,
    cloudwatchLogs: Optional[zio.aws.iot.model.CloudwatchLogsAction] =
      Optional.Absent,
    elasticsearch: Optional[zio.aws.iot.model.ElasticsearchAction] =
      Optional.Absent,
    salesforce: Optional[zio.aws.iot.model.SalesforceAction] = Optional.Absent,
    iotAnalytics: Optional[zio.aws.iot.model.IotAnalyticsAction] =
      Optional.Absent,
    iotEvents: Optional[zio.aws.iot.model.IotEventsAction] = Optional.Absent,
    iotSiteWise: Optional[zio.aws.iot.model.IotSiteWiseAction] =
      Optional.Absent,
    stepFunctions: Optional[zio.aws.iot.model.StepFunctionsAction] =
      Optional.Absent,
    timestream: Optional[zio.aws.iot.model.TimestreamAction] = Optional.Absent,
    http: Optional[zio.aws.iot.model.HttpAction] = Optional.Absent,
    kafka: Optional[zio.aws.iot.model.KafkaAction] = Optional.Absent,
    openSearch: Optional[zio.aws.iot.model.OpenSearchAction] = Optional.Absent,
    location: Optional[zio.aws.iot.model.LocationAction] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Action
      .builder()
      .optionallyWith(dynamoDB.map(value => value.buildAwsValue()))(_.dynamoDB)
      .optionallyWith(dynamoDBv2.map(value => value.buildAwsValue()))(
        _.dynamoDBv2
      )
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .optionallyWith(sns.map(value => value.buildAwsValue()))(_.sns)
      .optionallyWith(sqs.map(value => value.buildAwsValue()))(_.sqs)
      .optionallyWith(kinesis.map(value => value.buildAwsValue()))(_.kinesis)
      .optionallyWith(republish.map(value => value.buildAwsValue()))(
        _.republish
      )
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(cloudwatchMetric.map(value => value.buildAwsValue()))(
        _.cloudwatchMetric
      )
      .optionallyWith(cloudwatchAlarm.map(value => value.buildAwsValue()))(
        _.cloudwatchAlarm
      )
      .optionallyWith(cloudwatchLogs.map(value => value.buildAwsValue()))(
        _.cloudwatchLogs
      )
      .optionallyWith(elasticsearch.map(value => value.buildAwsValue()))(
        _.elasticsearch
      )
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(iotAnalytics.map(value => value.buildAwsValue()))(
        _.iotAnalytics
      )
      .optionallyWith(iotEvents.map(value => value.buildAwsValue()))(
        _.iotEvents
      )
      .optionallyWith(iotSiteWise.map(value => value.buildAwsValue()))(
        _.iotSiteWise
      )
      .optionallyWith(stepFunctions.map(value => value.buildAwsValue()))(
        _.stepFunctions
      )
      .optionallyWith(timestream.map(value => value.buildAwsValue()))(
        _.timestream
      )
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(kafka.map(value => value.buildAwsValue()))(_.kafka)
      .optionallyWith(openSearch.map(value => value.buildAwsValue()))(
        _.openSearch
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Action.ReadOnly =
    zio.aws.iot.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Action = zio.aws.iot.model.Action(
      dynamoDB.map(value => value.asEditable),
      dynamoDBv2.map(value => value.asEditable),
      lambda.map(value => value.asEditable),
      sns.map(value => value.asEditable),
      sqs.map(value => value.asEditable),
      kinesis.map(value => value.asEditable),
      republish.map(value => value.asEditable),
      s3.map(value => value.asEditable),
      firehose.map(value => value.asEditable),
      cloudwatchMetric.map(value => value.asEditable),
      cloudwatchAlarm.map(value => value.asEditable),
      cloudwatchLogs.map(value => value.asEditable),
      elasticsearch.map(value => value.asEditable),
      salesforce.map(value => value.asEditable),
      iotAnalytics.map(value => value.asEditable),
      iotEvents.map(value => value.asEditable),
      iotSiteWise.map(value => value.asEditable),
      stepFunctions.map(value => value.asEditable),
      timestream.map(value => value.asEditable),
      http.map(value => value.asEditable),
      kafka.map(value => value.asEditable),
      openSearch.map(value => value.asEditable),
      location.map(value => value.asEditable)
    )
    def dynamoDB: Optional[zio.aws.iot.model.DynamoDBAction.ReadOnly]
    def dynamoDBv2: Optional[zio.aws.iot.model.DynamoDBv2Action.ReadOnly]
    def lambda: Optional[zio.aws.iot.model.LambdaAction.ReadOnly]
    def sns: Optional[zio.aws.iot.model.SnsAction.ReadOnly]
    def sqs: Optional[zio.aws.iot.model.SqsAction.ReadOnly]
    def kinesis: Optional[zio.aws.iot.model.KinesisAction.ReadOnly]
    def republish: Optional[zio.aws.iot.model.RepublishAction.ReadOnly]
    def s3: Optional[zio.aws.iot.model.S3Action.ReadOnly]
    def firehose: Optional[zio.aws.iot.model.FirehoseAction.ReadOnly]
    def cloudwatchMetric
        : Optional[zio.aws.iot.model.CloudwatchMetricAction.ReadOnly]
    def cloudwatchAlarm
        : Optional[zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly]
    def cloudwatchLogs
        : Optional[zio.aws.iot.model.CloudwatchLogsAction.ReadOnly]
    def elasticsearch: Optional[zio.aws.iot.model.ElasticsearchAction.ReadOnly]
    def salesforce: Optional[zio.aws.iot.model.SalesforceAction.ReadOnly]
    def iotAnalytics: Optional[zio.aws.iot.model.IotAnalyticsAction.ReadOnly]
    def iotEvents: Optional[zio.aws.iot.model.IotEventsAction.ReadOnly]
    def iotSiteWise: Optional[zio.aws.iot.model.IotSiteWiseAction.ReadOnly]
    def stepFunctions: Optional[zio.aws.iot.model.StepFunctionsAction.ReadOnly]
    def timestream: Optional[zio.aws.iot.model.TimestreamAction.ReadOnly]
    def http: Optional[zio.aws.iot.model.HttpAction.ReadOnly]
    def kafka: Optional[zio.aws.iot.model.KafkaAction.ReadOnly]
    def openSearch: Optional[zio.aws.iot.model.OpenSearchAction.ReadOnly]
    def location: Optional[zio.aws.iot.model.LocationAction.ReadOnly]
    def getDynamoDB
        : ZIO[Any, AwsError, zio.aws.iot.model.DynamoDBAction.ReadOnly] =
      AwsError.unwrapOptionField("dynamoDB", dynamoDB)
    def getDynamoDBv2
        : ZIO[Any, AwsError, zio.aws.iot.model.DynamoDBv2Action.ReadOnly] =
      AwsError.unwrapOptionField("dynamoDBv2", dynamoDBv2)
    def getLambda: ZIO[Any, AwsError, zio.aws.iot.model.LambdaAction.ReadOnly] =
      AwsError.unwrapOptionField("lambda", lambda)
    def getSns: ZIO[Any, AwsError, zio.aws.iot.model.SnsAction.ReadOnly] =
      AwsError.unwrapOptionField("sns", sns)
    def getSqs: ZIO[Any, AwsError, zio.aws.iot.model.SqsAction.ReadOnly] =
      AwsError.unwrapOptionField("sqs", sqs)
    def getKinesis
        : ZIO[Any, AwsError, zio.aws.iot.model.KinesisAction.ReadOnly] =
      AwsError.unwrapOptionField("kinesis", kinesis)
    def getRepublish
        : ZIO[Any, AwsError, zio.aws.iot.model.RepublishAction.ReadOnly] =
      AwsError.unwrapOptionField("republish", republish)
    def getS3: ZIO[Any, AwsError, zio.aws.iot.model.S3Action.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
    def getFirehose
        : ZIO[Any, AwsError, zio.aws.iot.model.FirehoseAction.ReadOnly] =
      AwsError.unwrapOptionField("firehose", firehose)
    def getCloudwatchMetric: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.CloudwatchMetricAction.ReadOnly
    ] = AwsError.unwrapOptionField("cloudwatchMetric", cloudwatchMetric)
    def getCloudwatchAlarm
        : ZIO[Any, AwsError, zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly] =
      AwsError.unwrapOptionField("cloudwatchAlarm", cloudwatchAlarm)
    def getCloudwatchLogs
        : ZIO[Any, AwsError, zio.aws.iot.model.CloudwatchLogsAction.ReadOnly] =
      AwsError.unwrapOptionField("cloudwatchLogs", cloudwatchLogs)
    def getElasticsearch
        : ZIO[Any, AwsError, zio.aws.iot.model.ElasticsearchAction.ReadOnly] =
      AwsError.unwrapOptionField("elasticsearch", elasticsearch)
    def getSalesforce
        : ZIO[Any, AwsError, zio.aws.iot.model.SalesforceAction.ReadOnly] =
      AwsError.unwrapOptionField("salesforce", salesforce)
    def getIotAnalytics
        : ZIO[Any, AwsError, zio.aws.iot.model.IotAnalyticsAction.ReadOnly] =
      AwsError.unwrapOptionField("iotAnalytics", iotAnalytics)
    def getIotEvents
        : ZIO[Any, AwsError, zio.aws.iot.model.IotEventsAction.ReadOnly] =
      AwsError.unwrapOptionField("iotEvents", iotEvents)
    def getIotSiteWise
        : ZIO[Any, AwsError, zio.aws.iot.model.IotSiteWiseAction.ReadOnly] =
      AwsError.unwrapOptionField("iotSiteWise", iotSiteWise)
    def getStepFunctions
        : ZIO[Any, AwsError, zio.aws.iot.model.StepFunctionsAction.ReadOnly] =
      AwsError.unwrapOptionField("stepFunctions", stepFunctions)
    def getTimestream
        : ZIO[Any, AwsError, zio.aws.iot.model.TimestreamAction.ReadOnly] =
      AwsError.unwrapOptionField("timestream", timestream)
    def getHttp: ZIO[Any, AwsError, zio.aws.iot.model.HttpAction.ReadOnly] =
      AwsError.unwrapOptionField("http", http)
    def getKafka: ZIO[Any, AwsError, zio.aws.iot.model.KafkaAction.ReadOnly] =
      AwsError.unwrapOptionField("kafka", kafka)
    def getOpenSearch
        : ZIO[Any, AwsError, zio.aws.iot.model.OpenSearchAction.ReadOnly] =
      AwsError.unwrapOptionField("openSearch", openSearch)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.iot.model.LocationAction.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Action
  ) extends zio.aws.iot.model.Action.ReadOnly {
    override val dynamoDB: Optional[zio.aws.iot.model.DynamoDBAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamoDB())
        .map(value => zio.aws.iot.model.DynamoDBAction.wrap(value))
    override val dynamoDBv2
        : Optional[zio.aws.iot.model.DynamoDBv2Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamoDBv2())
        .map(value => zio.aws.iot.model.DynamoDBv2Action.wrap(value))
    override val lambda: Optional[zio.aws.iot.model.LambdaAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambda())
        .map(value => zio.aws.iot.model.LambdaAction.wrap(value))
    override val sns: Optional[zio.aws.iot.model.SnsAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sns())
        .map(value => zio.aws.iot.model.SnsAction.wrap(value))
    override val sqs: Optional[zio.aws.iot.model.SqsAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqs())
        .map(value => zio.aws.iot.model.SqsAction.wrap(value))
    override val kinesis: Optional[zio.aws.iot.model.KinesisAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesis())
        .map(value => zio.aws.iot.model.KinesisAction.wrap(value))
    override val republish
        : Optional[zio.aws.iot.model.RepublishAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.republish())
        .map(value => zio.aws.iot.model.RepublishAction.wrap(value))
    override val s3: Optional[zio.aws.iot.model.S3Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.iot.model.S3Action.wrap(value))
    override val firehose: Optional[zio.aws.iot.model.FirehoseAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehose())
        .map(value => zio.aws.iot.model.FirehoseAction.wrap(value))
    override val cloudwatchMetric
        : Optional[zio.aws.iot.model.CloudwatchMetricAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudwatchMetric())
        .map(value => zio.aws.iot.model.CloudwatchMetricAction.wrap(value))
    override val cloudwatchAlarm
        : Optional[zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudwatchAlarm())
        .map(value => zio.aws.iot.model.CloudwatchAlarmAction.wrap(value))
    override val cloudwatchLogs
        : Optional[zio.aws.iot.model.CloudwatchLogsAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudwatchLogs())
        .map(value => zio.aws.iot.model.CloudwatchLogsAction.wrap(value))
    override val elasticsearch
        : Optional[zio.aws.iot.model.ElasticsearchAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticsearch())
        .map(value => zio.aws.iot.model.ElasticsearchAction.wrap(value))
    override val salesforce
        : Optional[zio.aws.iot.model.SalesforceAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.salesforce())
        .map(value => zio.aws.iot.model.SalesforceAction.wrap(value))
    override val iotAnalytics
        : Optional[zio.aws.iot.model.IotAnalyticsAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iotAnalytics())
        .map(value => zio.aws.iot.model.IotAnalyticsAction.wrap(value))
    override val iotEvents
        : Optional[zio.aws.iot.model.IotEventsAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iotEvents())
        .map(value => zio.aws.iot.model.IotEventsAction.wrap(value))
    override val iotSiteWise
        : Optional[zio.aws.iot.model.IotSiteWiseAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iotSiteWise())
        .map(value => zio.aws.iot.model.IotSiteWiseAction.wrap(value))
    override val stepFunctions
        : Optional[zio.aws.iot.model.StepFunctionsAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepFunctions())
        .map(value => zio.aws.iot.model.StepFunctionsAction.wrap(value))
    override val timestream
        : Optional[zio.aws.iot.model.TimestreamAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestream())
        .map(value => zio.aws.iot.model.TimestreamAction.wrap(value))
    override val http: Optional[zio.aws.iot.model.HttpAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.http())
        .map(value => zio.aws.iot.model.HttpAction.wrap(value))
    override val kafka: Optional[zio.aws.iot.model.KafkaAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kafka())
        .map(value => zio.aws.iot.model.KafkaAction.wrap(value))
    override val openSearch
        : Optional[zio.aws.iot.model.OpenSearchAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openSearch())
        .map(value => zio.aws.iot.model.OpenSearchAction.wrap(value))
    override val location: Optional[zio.aws.iot.model.LocationAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.iot.model.LocationAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Action
  ): zio.aws.iot.model.Action.ReadOnly = new Wrapper(impl)
}
