package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AuditDescription,
  SuppressIndefinitely,
  Timestamp,
  AuditCheckName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AuditSuppression(
    checkName: AuditCheckName,
    resourceIdentifier: zio.aws.iot.model.ResourceIdentifier,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    suppressIndefinitely: Optional[SuppressIndefinitely] = Optional.Absent,
    description: Optional[AuditDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditSuppression = {
    import AuditSuppression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditSuppression
      .builder()
      .checkName(AuditCheckName.unwrap(checkName): java.lang.String)
      .resourceIdentifier(resourceIdentifier.buildAwsValue())
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        suppressIndefinitely.map(value =>
          SuppressIndefinitely.unwrap(value): java.lang.Boolean
        )
      )(_.suppressIndefinitely)
      .optionallyWith(
        description.map(value =>
          AuditDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditSuppression.ReadOnly =
    zio.aws.iot.model.AuditSuppression.wrap(buildAwsValue())
}
object AuditSuppression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditSuppression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditSuppression =
      zio.aws.iot.model.AuditSuppression(
        checkName,
        resourceIdentifier.asEditable,
        expirationDate.map(value => value),
        suppressIndefinitely.map(value => value),
        description.map(value => value)
      )
    def checkName: AuditCheckName
    def resourceIdentifier: zio.aws.iot.model.ResourceIdentifier.ReadOnly
    def expirationDate: Optional[Timestamp]
    def suppressIndefinitely: Optional[SuppressIndefinitely]
    def description: Optional[AuditDescription]
    def getCheckName: ZIO[Any, Nothing, AuditCheckName] = ZIO.succeed(checkName)
    def getResourceIdentifier
        : ZIO[Any, Nothing, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      ZIO.succeed(resourceIdentifier)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getSuppressIndefinitely: ZIO[Any, AwsError, SuppressIndefinitely] =
      AwsError.unwrapOptionField("suppressIndefinitely", suppressIndefinitely)
    def getDescription: ZIO[Any, AwsError, AuditDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditSuppression
  ) extends zio.aws.iot.model.AuditSuppression.ReadOnly {
    override val checkName: AuditCheckName =
      zio.aws.iot.model.primitives.AuditCheckName(impl.checkName())
    override val resourceIdentifier
        : zio.aws.iot.model.ResourceIdentifier.ReadOnly =
      zio.aws.iot.model.ResourceIdentifier.wrap(impl.resourceIdentifier())
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val suppressIndefinitely: Optional[SuppressIndefinitely] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressIndefinitely())
        .map(value => zio.aws.iot.model.primitives.SuppressIndefinitely(value))
    override val description: Optional[AuditDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.AuditDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditSuppression
  ): zio.aws.iot.model.AuditSuppression.ReadOnly = new Wrapper(impl)
}
