package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait AutoRegistrationStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.AutoRegistrationStatus
}
object AutoRegistrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AutoRegistrationStatus
  ): zio.aws.iot.model.AutoRegistrationStatus = value match {
    case software.amazon.awssdk.services.iot.model.AutoRegistrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AutoRegistrationStatus.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.iot.model.AutoRegistrationStatus.DISABLE =>
      val r = DISABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.AutoRegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AutoRegistrationStatus =
      software.amazon.awssdk.services.iot.model.AutoRegistrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE extends zio.aws.iot.model.AutoRegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AutoRegistrationStatus =
      software.amazon.awssdk.services.iot.model.AutoRegistrationStatus.ENABLE
  }
  case object DISABLE extends zio.aws.iot.model.AutoRegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AutoRegistrationStatus =
      software.amazon.awssdk.services.iot.model.AutoRegistrationStatus.DISABLE
  }
}
