package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AwsJobAbortConfig(
    abortCriteriaList: Iterable[zio.aws.iot.model.AwsJobAbortCriteria]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobAbortConfig = {
    import AwsJobAbortConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobAbortConfig
      .builder()
      .abortCriteriaList(abortCriteriaList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobAbortConfig.ReadOnly =
    zio.aws.iot.model.AwsJobAbortConfig.wrap(buildAwsValue())
}
object AwsJobAbortConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobAbortConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobAbortConfig =
      zio.aws.iot.model.AwsJobAbortConfig(abortCriteriaList.map { item =>
        item.asEditable
      })
    def abortCriteriaList: List[zio.aws.iot.model.AwsJobAbortCriteria.ReadOnly]
    def getAbortCriteriaList: ZIO[Any, Nothing, List[
      zio.aws.iot.model.AwsJobAbortCriteria.ReadOnly
    ]] = ZIO.succeed(abortCriteriaList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobAbortConfig
  ) extends zio.aws.iot.model.AwsJobAbortConfig.ReadOnly {
    override val abortCriteriaList
        : List[zio.aws.iot.model.AwsJobAbortCriteria.ReadOnly] = impl
      .abortCriteriaList()
      .asScala
      .map { item =>
        zio.aws.iot.model.AwsJobAbortCriteria.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobAbortConfig
  ): zio.aws.iot.model.AwsJobAbortConfig.ReadOnly = new Wrapper(impl)
}
