package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  SuppressAlerts,
  BehaviorMetric,
  BehaviorName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Behavior(
    name: BehaviorName,
    metric: Optional[BehaviorMetric] = Optional.Absent,
    metricDimension: Optional[zio.aws.iot.model.MetricDimension] =
      Optional.Absent,
    criteria: Optional[zio.aws.iot.model.BehaviorCriteria] = Optional.Absent,
    suppressAlerts: Optional[SuppressAlerts] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Behavior = {
    import Behavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Behavior
      .builder()
      .name(BehaviorName.unwrap(name): java.lang.String)
      .optionallyWith(
        metric.map(value => BehaviorMetric.unwrap(value): java.lang.String)
      )(_.metric)
      .optionallyWith(metricDimension.map(value => value.buildAwsValue()))(
        _.metricDimension
      )
      .optionallyWith(criteria.map(value => value.buildAwsValue()))(_.criteria)
      .optionallyWith(
        suppressAlerts.map(value =>
          SuppressAlerts.unwrap(value): java.lang.Boolean
        )
      )(_.suppressAlerts)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Behavior.ReadOnly =
    zio.aws.iot.model.Behavior.wrap(buildAwsValue())
}
object Behavior {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Behavior] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Behavior = zio.aws.iot.model.Behavior(
      name,
      metric.map(value => value),
      metricDimension.map(value => value.asEditable),
      criteria.map(value => value.asEditable),
      suppressAlerts.map(value => value)
    )
    def name: BehaviorName
    def metric: Optional[BehaviorMetric]
    def metricDimension: Optional[zio.aws.iot.model.MetricDimension.ReadOnly]
    def criteria: Optional[zio.aws.iot.model.BehaviorCriteria.ReadOnly]
    def suppressAlerts: Optional[SuppressAlerts]
    def getName: ZIO[Any, Nothing, BehaviorName] = ZIO.succeed(name)
    def getMetric: ZIO[Any, AwsError, BehaviorMetric] =
      AwsError.unwrapOptionField("metric", metric)
    def getMetricDimension
        : ZIO[Any, AwsError, zio.aws.iot.model.MetricDimension.ReadOnly] =
      AwsError.unwrapOptionField("metricDimension", metricDimension)
    def getCriteria
        : ZIO[Any, AwsError, zio.aws.iot.model.BehaviorCriteria.ReadOnly] =
      AwsError.unwrapOptionField("criteria", criteria)
    def getSuppressAlerts: ZIO[Any, AwsError, SuppressAlerts] =
      AwsError.unwrapOptionField("suppressAlerts", suppressAlerts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Behavior
  ) extends zio.aws.iot.model.Behavior.ReadOnly {
    override val name: BehaviorName =
      zio.aws.iot.model.primitives.BehaviorName(impl.name())
    override val metric: Optional[BehaviorMetric] = zio.aws.core.internal
      .optionalFromNullable(impl.metric())
      .map(value => zio.aws.iot.model.primitives.BehaviorMetric(value))
    override val metricDimension
        : Optional[zio.aws.iot.model.MetricDimension.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDimension())
        .map(value => zio.aws.iot.model.MetricDimension.wrap(value))
    override val criteria
        : Optional[zio.aws.iot.model.BehaviorCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.criteria())
        .map(value => zio.aws.iot.model.BehaviorCriteria.wrap(value))
    override val suppressAlerts: Optional[SuppressAlerts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressAlerts())
        .map(value => zio.aws.iot.model.primitives.SuppressAlerts(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Behavior
  ): zio.aws.iot.model.Behavior.ReadOnly = new Wrapper(impl)
}
