package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionsTaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelDetectMitigationActionsTaskRequest(
    taskId: MitigationActionsTaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest = {
    import CancelDetectMitigationActionsTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CancelDetectMitigationActionsTaskRequest.ReadOnly =
    zio.aws.iot.model.CancelDetectMitigationActionsTaskRequest
      .wrap(buildAwsValue())
}
object CancelDetectMitigationActionsTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelDetectMitigationActionsTaskRequest =
      zio.aws.iot.model.CancelDetectMitigationActionsTaskRequest(taskId)
    def taskId: MitigationActionsTaskId
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest
  ) extends zio.aws.iot.model.CancelDetectMitigationActionsTaskRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest
  ): zio.aws.iot.model.CancelDetectMitigationActionsTaskRequest.ReadOnly =
    new Wrapper(impl)
}
