package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SetAsActive, CertificateSigningRequest}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCertificateFromCsrRequest(
    certificateSigningRequest: CertificateSigningRequest,
    setAsActive: Optional[SetAsActive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest = {
    import CreateCertificateFromCsrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest
      .builder()
      .certificateSigningRequest(
        CertificateSigningRequest.unwrap(
          certificateSigningRequest
        ): java.lang.String
      )
      .optionallyWith(
        setAsActive.map(value => SetAsActive.unwrap(value): java.lang.Boolean)
      )(_.setAsActive)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateCertificateFromCsrRequest.ReadOnly =
    zio.aws.iot.model.CreateCertificateFromCsrRequest.wrap(buildAwsValue())
}
object CreateCertificateFromCsrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateCertificateFromCsrRequest =
      zio.aws.iot.model.CreateCertificateFromCsrRequest(
        certificateSigningRequest,
        setAsActive.map(value => value)
      )
    def certificateSigningRequest: CertificateSigningRequest
    def setAsActive: Optional[SetAsActive]
    def getCertificateSigningRequest
        : ZIO[Any, Nothing, CertificateSigningRequest] =
      ZIO.succeed(certificateSigningRequest)
    def getSetAsActive: ZIO[Any, AwsError, SetAsActive] =
      AwsError.unwrapOptionField("setAsActive", setAsActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest
  ) extends zio.aws.iot.model.CreateCertificateFromCsrRequest.ReadOnly {
    override val certificateSigningRequest: CertificateSigningRequest =
      zio.aws.iot.model.primitives
        .CertificateSigningRequest(impl.certificateSigningRequest())
    override val setAsActive: Optional[SetAsActive] = zio.aws.core.internal
      .optionalFromNullable(impl.setAsActive())
      .map(value => zio.aws.iot.model.primitives.SetAsActive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest
  ): zio.aws.iot.model.CreateCertificateFromCsrRequest.ReadOnly = new Wrapper(
    impl
  )
}
