package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ClientRequestToken,
  DimensionStringValue,
  DimensionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDimensionRequest(
    name: DimensionName,
    `type`: zio.aws.iot.model.DimensionType,
    stringValues: Iterable[DimensionStringValue],
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDimensionRequest = {
    import CreateDimensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDimensionRequest
      .builder()
      .name(DimensionName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .stringValues(stringValues.map { item =>
        DimensionStringValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDimensionRequest.ReadOnly =
    zio.aws.iot.model.CreateDimensionRequest.wrap(buildAwsValue())
}
object CreateDimensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDimensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDimensionRequest =
      zio.aws.iot.model.CreateDimensionRequest(
        name,
        `type`,
        stringValues,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken
      )
    def name: DimensionName
    def `type`: zio.aws.iot.model.DimensionType
    def stringValues: List[DimensionStringValue]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def clientRequestToken: ClientRequestToken
    def getName: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.iot.model.DimensionType] =
      ZIO.succeed(`type`)
    def getStringValues: ZIO[Any, Nothing, List[DimensionStringValue]] =
      ZIO.succeed(stringValues)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDimensionRequest
  ) extends zio.aws.iot.model.CreateDimensionRequest.ReadOnly {
    override val name: DimensionName =
      zio.aws.iot.model.primitives.DimensionName(impl.name())
    override val `type`: zio.aws.iot.model.DimensionType =
      zio.aws.iot.model.DimensionType.wrap(impl.`type`())
    override val stringValues: List[DimensionStringValue] = impl
      .stringValues()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.DimensionStringValue(item)
      }
      .toList
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: ClientRequestToken =
      zio.aws.iot.model.primitives.ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDimensionRequest
  ): zio.aws.iot.model.CreateDimensionRequest.ReadOnly = new Wrapper(impl)
}
