package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AcmCertificateArn,
  DomainName,
  DomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDomainConfigurationRequest(
    domainConfigurationName: DomainConfigurationName,
    domainName: Optional[DomainName] = Optional.Absent,
    serverCertificateArns: Optional[Iterable[AcmCertificateArn]] =
      Optional.Absent,
    validationCertificateArn: Optional[AcmCertificateArn] = Optional.Absent,
    authorizerConfig: Optional[zio.aws.iot.model.AuthorizerConfig] =
      Optional.Absent,
    serviceType: Optional[zio.aws.iot.model.ServiceType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest = {
    import CreateDomainConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest
      .builder()
      .domainConfigurationName(
        DomainConfigurationName.unwrap(
          domainConfigurationName
        ): java.lang.String
      )
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        serverCertificateArns.map(value =>
          value.map { item =>
            AcmCertificateArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.serverCertificateArns)
      .optionallyWith(
        validationCertificateArn.map(value =>
          AcmCertificateArn.unwrap(value): java.lang.String
        )
      )(_.validationCertificateArn)
      .optionallyWith(authorizerConfig.map(value => value.buildAwsValue()))(
        _.authorizerConfig
      )
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDomainConfigurationRequest.ReadOnly =
    zio.aws.iot.model.CreateDomainConfigurationRequest.wrap(buildAwsValue())
}
object CreateDomainConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDomainConfigurationRequest =
      zio.aws.iot.model.CreateDomainConfigurationRequest(
        domainConfigurationName,
        domainName.map(value => value),
        serverCertificateArns.map(value => value),
        validationCertificateArn.map(value => value),
        authorizerConfig.map(value => value.asEditable),
        serviceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainConfigurationName: DomainConfigurationName
    def domainName: Optional[DomainName]
    def serverCertificateArns: Optional[List[AcmCertificateArn]]
    def validationCertificateArn: Optional[AcmCertificateArn]
    def authorizerConfig: Optional[zio.aws.iot.model.AuthorizerConfig.ReadOnly]
    def serviceType: Optional[zio.aws.iot.model.ServiceType]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getDomainConfigurationName: ZIO[Any, Nothing, DomainConfigurationName] =
      ZIO.succeed(domainConfigurationName)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getServerCertificateArns: ZIO[Any, AwsError, List[AcmCertificateArn]] =
      AwsError.unwrapOptionField("serverCertificateArns", serverCertificateArns)
    def getValidationCertificateArn: ZIO[Any, AwsError, AcmCertificateArn] =
      AwsError.unwrapOptionField(
        "validationCertificateArn",
        validationCertificateArn
      )
    def getAuthorizerConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerConfig.ReadOnly] =
      AwsError.unwrapOptionField("authorizerConfig", authorizerConfig)
    def getServiceType: ZIO[Any, AwsError, zio.aws.iot.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest
  ) extends zio.aws.iot.model.CreateDomainConfigurationRequest.ReadOnly {
    override val domainConfigurationName: DomainConfigurationName =
      zio.aws.iot.model.primitives
        .DomainConfigurationName(impl.domainConfigurationName())
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.iot.model.primitives.DomainName(value))
    override val serverCertificateArns: Optional[List[AcmCertificateArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverCertificateArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.AcmCertificateArn(item)
          }.toList
        )
    override val validationCertificateArn: Optional[AcmCertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationCertificateArn())
        .map(value => zio.aws.iot.model.primitives.AcmCertificateArn(value))
    override val authorizerConfig
        : Optional[zio.aws.iot.model.AuthorizerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerConfig())
        .map(value => zio.aws.iot.model.AuthorizerConfig.wrap(value))
    override val serviceType: Optional[zio.aws.iot.model.ServiceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceType())
        .map(value => zio.aws.iot.model.ServiceType.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest
  ): zio.aws.iot.model.CreateDomainConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
