package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ParameterKey,
  TargetArn,
  NamespaceId,
  ParameterValue,
  JobTemplateArn,
  JobDocument,
  JobDocumentSource,
  JobId,
  JobDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateJobRequest(
    jobId: JobId,
    targets: Iterable[TargetArn],
    documentSource: Optional[JobDocumentSource] = Optional.Absent,
    document: Optional[JobDocument] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    presignedUrlConfig: Optional[zio.aws.iot.model.PresignedUrlConfig] =
      Optional.Absent,
    targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      Optional.Absent,
    jobExecutionsRolloutConfig: Optional[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = Optional.Absent,
    abortConfig: Optional[zio.aws.iot.model.AbortConfig] = Optional.Absent,
    timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent,
    namespaceId: Optional[NamespaceId] = Optional.Absent,
    jobTemplateArn: Optional[JobTemplateArn] = Optional.Absent,
    jobExecutionsRetryConfig: Optional[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = Optional.Absent,
    documentParameters: Optional[Map[ParameterKey, ParameterValue]] =
      Optional.Absent,
    schedulingConfig: Optional[zio.aws.iot.model.SchedulingConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .targets(targets.map { item =>
        TargetArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .optionallyWith(
        documentParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.documentParameters)
      .optionallyWith(schedulingConfig.map(value => value.buildAwsValue()))(
        _.schedulingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateJobRequest.ReadOnly =
    zio.aws.iot.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateJobRequest =
      zio.aws.iot.model.CreateJobRequest(
        jobId,
        targets,
        documentSource.map(value => value),
        document.map(value => value),
        description.map(value => value),
        presignedUrlConfig.map(value => value.asEditable),
        targetSelection.map(value => value),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        namespaceId.map(value => value),
        jobTemplateArn.map(value => value),
        jobExecutionsRetryConfig.map(value => value.asEditable),
        documentParameters.map(value => value),
        schedulingConfig.map(value => value.asEditable)
      )
    def jobId: JobId
    def targets: List[TargetArn]
    def documentSource: Optional[JobDocumentSource]
    def document: Optional[JobDocument]
    def description: Optional[JobDescription]
    def presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def targetSelection: Optional[zio.aws.iot.model.TargetSelection]
    def jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def namespaceId: Optional[NamespaceId]
    def jobTemplateArn: Optional[JobTemplateArn]
    def jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def documentParameters: Optional[Map[ParameterKey, ParameterValue]]
    def schedulingConfig: Optional[zio.aws.iot.model.SchedulingConfig.ReadOnly]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getTargets: ZIO[Any, Nothing, List[TargetArn]] = ZIO.succeed(targets)
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
    def getDocumentParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField("documentParameters", documentParameters)
    def getSchedulingConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.SchedulingConfig.ReadOnly] =
      AwsError.unwrapOptionField("schedulingConfig", schedulingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateJobRequest
  ) extends zio.aws.iot.model.CreateJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val targets: List[TargetArn] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.TargetArn(item)
      }
      .toList
    override val documentSource: Optional[JobDocumentSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentSource())
        .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val document: Optional[JobDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presignedUrlConfig())
        .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRolloutConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
    override val namespaceId: Optional[NamespaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val jobTemplateArn: Optional[JobTemplateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTemplateArn())
        .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRetryConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
    override val documentParameters
        : Optional[Map[ParameterKey, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.documentParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.ParameterKey(
              key
            ) -> zio.aws.iot.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val schedulingConfig
        : Optional[zio.aws.iot.model.SchedulingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedulingConfig())
        .map(value => zio.aws.iot.model.SchedulingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateJobRequest
  ): zio.aws.iot.model.CreateJobRequest.ReadOnly = new Wrapper(impl)
}
