package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SetAsDefault, PolicyDocument, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePolicyVersionRequest(
    policyName: PolicyName,
    policyDocument: PolicyDocument,
    setAsDefault: Optional[SetAsDefault] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest = {
    import CreatePolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyDocument(PolicyDocument.unwrap(policyDocument): java.lang.String)
      .optionallyWith(
        setAsDefault.map(value => SetAsDefault.unwrap(value): java.lang.Boolean)
      )(_.setAsDefault)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreatePolicyVersionRequest.ReadOnly =
    zio.aws.iot.model.CreatePolicyVersionRequest.wrap(buildAwsValue())
}
object CreatePolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreatePolicyVersionRequest =
      zio.aws.iot.model.CreatePolicyVersionRequest(
        policyName,
        policyDocument,
        setAsDefault.map(value => value)
      )
    def policyName: PolicyName
    def policyDocument: PolicyDocument
    def setAsDefault: Optional[SetAsDefault]
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocument] =
      ZIO.succeed(policyDocument)
    def getSetAsDefault: ZIO[Any, AwsError, SetAsDefault] =
      AwsError.unwrapOptionField("setAsDefault", setAsDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest
  ) extends zio.aws.iot.model.CreatePolicyVersionRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val policyDocument: PolicyDocument =
      zio.aws.iot.model.primitives.PolicyDocument(impl.policyDocument())
    override val setAsDefault: Optional[SetAsDefault] = zio.aws.core.internal
      .optionalFromNullable(impl.setAsDefault())
      .map(value => zio.aws.iot.model.primitives.SetAsDefault(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest
  ): zio.aws.iot.model.CreatePolicyVersionRequest.ReadOnly = new Wrapper(impl)
}
