package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCaCertificateRequest(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest = {
    import DeleteCaCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteCaCertificateRequest.ReadOnly =
    zio.aws.iot.model.DeleteCaCertificateRequest.wrap(buildAwsValue())
}
object DeleteCaCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteCaCertificateRequest =
      zio.aws.iot.model.DeleteCaCertificateRequest(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest
  ) extends zio.aws.iot.model.DeleteCaCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest
  ): zio.aws.iot.model.DeleteCaCertificateRequest.ReadOnly = new Wrapper(impl)
}
