package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{TemplateVersionId, TemplateName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteProvisioningTemplateVersionRequest(
    templateName: TemplateName,
    versionId: TemplateVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest = {
    import DeleteProvisioningTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .versionId(TemplateVersionId.unwrap(versionId): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DeleteProvisioningTemplateVersionRequest.ReadOnly =
    zio.aws.iot.model.DeleteProvisioningTemplateVersionRequest
      .wrap(buildAwsValue())
}
object DeleteProvisioningTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteProvisioningTemplateVersionRequest =
      zio.aws.iot.model
        .DeleteProvisioningTemplateVersionRequest(templateName, versionId)
    def templateName: TemplateName
    def versionId: TemplateVersionId
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getVersionId: ZIO[Any, Nothing, TemplateVersionId] =
      ZIO.succeed(versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest
  ) extends zio.aws.iot.model.DeleteProvisioningTemplateVersionRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
    override val versionId: TemplateVersionId =
      zio.aws.iot.model.primitives.TemplateVersionId(impl.versionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest
  ): zio.aws.iot.model.DeleteProvisioningTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
