package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{UndoDeprecate, ThingTypeName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeprecateThingTypeRequest(
    thingTypeName: ThingTypeName,
    undoDeprecate: Optional[UndoDeprecate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest = {
    import DeprecateThingTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest
      .builder()
      .thingTypeName(ThingTypeName.unwrap(thingTypeName): java.lang.String)
      .optionallyWith(
        undoDeprecate.map(value =>
          UndoDeprecate.unwrap(value): java.lang.Boolean
        )
      )(_.undoDeprecate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeprecateThingTypeRequest.ReadOnly =
    zio.aws.iot.model.DeprecateThingTypeRequest.wrap(buildAwsValue())
}
object DeprecateThingTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeprecateThingTypeRequest =
      zio.aws.iot.model.DeprecateThingTypeRequest(
        thingTypeName,
        undoDeprecate.map(value => value)
      )
    def thingTypeName: ThingTypeName
    def undoDeprecate: Optional[UndoDeprecate]
    def getThingTypeName: ZIO[Any, Nothing, ThingTypeName] =
      ZIO.succeed(thingTypeName)
    def getUndoDeprecate: ZIO[Any, AwsError, UndoDeprecate] =
      AwsError.unwrapOptionField("undoDeprecate", undoDeprecate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest
  ) extends zio.aws.iot.model.DeprecateThingTypeRequest.ReadOnly {
    override val thingTypeName: ThingTypeName =
      zio.aws.iot.model.primitives.ThingTypeName(impl.thingTypeName())
    override val undoDeprecate: Optional[UndoDeprecate] = zio.aws.core.internal
      .optionalFromNullable(impl.undoDeprecate())
      .map(value => zio.aws.iot.model.primitives.UndoDeprecate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest
  ): zio.aws.iot.model.DeprecateThingTypeRequest.ReadOnly = new Wrapper(impl)
}
