package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  MitigationActionName,
  AuditCheckName,
  Timestamp
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeAuditMitigationActionsTaskResponse(
    taskStatus: Optional[zio.aws.iot.model.AuditMitigationActionsTaskStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    taskStatistics: Optional[
      Map[AuditCheckName, zio.aws.iot.model.TaskStatisticsForAuditCheck]
    ] = Optional.Absent,
    target: Optional[zio.aws.iot.model.AuditMitigationActionsTaskTarget] =
      Optional.Absent,
    auditCheckToActionsMapping: Optional[
      Map[AuditCheckName, Iterable[MitigationActionName]]
    ] = Optional.Absent,
    actionsDefinition: Optional[Iterable[zio.aws.iot.model.MitigationAction]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse = {
    import DescribeAuditMitigationActionsTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
      .builder()
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        taskStatistics.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.taskStatistics)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        auditCheckToActionsMapping.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  MitigationActionName.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.auditCheckToActionsMapping)
      .optionallyWith(
        actionsDefinition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsDefinition)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse
      .wrap(buildAwsValue())
}
object DescribeAuditMitigationActionsTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse =
      zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse(
        taskStatus.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        taskStatistics.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        target.map(value => value.asEditable),
        auditCheckToActionsMapping.map(value => value),
        actionsDefinition.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskStatus: Optional[zio.aws.iot.model.AuditMitigationActionsTaskStatus]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def taskStatistics: Optional[Map[
      AuditCheckName,
      zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly
    ]]
    def target
        : Optional[zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly]
    def auditCheckToActionsMapping
        : Optional[Map[AuditCheckName, List[MitigationActionName]]]
    def actionsDefinition
        : Optional[List[zio.aws.iot.model.MitigationAction.ReadOnly]]
    def getTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskStatus
    ] = AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTaskStatistics: ZIO[Any, AwsError, Map[
      AuditCheckName,
      zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly
    ]] = AwsError.unwrapOptionField("taskStatistics", taskStatistics)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getAuditCheckToActionsMapping
        : ZIO[Any, AwsError, Map[AuditCheckName, List[MitigationActionName]]] =
      AwsError.unwrapOptionField(
        "auditCheckToActionsMapping",
        auditCheckToActionsMapping
      )
    def getActionsDefinition: ZIO[Any, AwsError, List[
      zio.aws.iot.model.MitigationAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsDefinition", actionsDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
  ) extends zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly {
    override val taskStatus
        : Optional[zio.aws.iot.model.AuditMitigationActionsTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsTaskStatus.wrap(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskStatistics: Optional[Map[
      AuditCheckName,
      zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskStatistics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AuditCheckName(
              key
            ) -> zio.aws.iot.model.TaskStatisticsForAuditCheck.wrap(value)
          })
          .toMap
      )
    override val target: Optional[
      zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value =>
        zio.aws.iot.model.AuditMitigationActionsTaskTarget.wrap(value)
      )
    override val auditCheckToActionsMapping
        : Optional[Map[AuditCheckName, List[MitigationActionName]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditCheckToActionsMapping())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .AuditCheckName(key) -> value.asScala.map { item =>
                zio.aws.iot.model.primitives.MitigationActionName(item)
              }.toList
            })
            .toMap
        )
    override val actionsDefinition
        : Optional[List[zio.aws.iot.model.MitigationAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsDefinition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MitigationAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
  ): zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly =
    new Wrapper(impl)
}
