package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCaCertificateResponse(
    certificateDescription: Optional[
      zio.aws.iot.model.CACertificateDescription
    ] = Optional.Absent,
    registrationConfig: Optional[zio.aws.iot.model.RegistrationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse = {
    import DescribeCaCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
      .builder()
      .optionallyWith(
        certificateDescription.map(value => value.buildAwsValue())
      )(_.certificateDescription)
      .optionallyWith(registrationConfig.map(value => value.buildAwsValue()))(
        _.registrationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly =
    zio.aws.iot.model.DescribeCaCertificateResponse.wrap(buildAwsValue())
}
object DescribeCaCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCaCertificateResponse =
      zio.aws.iot.model.DescribeCaCertificateResponse(
        certificateDescription.map(value => value.asEditable),
        registrationConfig.map(value => value.asEditable)
      )
    def certificateDescription
        : Optional[zio.aws.iot.model.CACertificateDescription.ReadOnly]
    def registrationConfig
        : Optional[zio.aws.iot.model.RegistrationConfig.ReadOnly]
    def getCertificateDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.CACertificateDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateDescription",
      certificateDescription
    )
    def getRegistrationConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      AwsError.unwrapOptionField("registrationConfig", registrationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
  ) extends zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly {
    override val certificateDescription
        : Optional[zio.aws.iot.model.CACertificateDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateDescription())
        .map(value => zio.aws.iot.model.CACertificateDescription.wrap(value))
    override val registrationConfig
        : Optional[zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationConfig())
        .map(value => zio.aws.iot.model.RegistrationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
  ): zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
