package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  IndexName,
  ThingGroupArn,
  Version,
  QueryVersion,
  QueryString,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeThingGroupResponse(
    thingGroupName: Optional[ThingGroupName] = Optional.Absent,
    thingGroupId: Optional[ThingGroupId] = Optional.Absent,
    thingGroupArn: Optional[ThingGroupArn] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    thingGroupProperties: Optional[zio.aws.iot.model.ThingGroupProperties] =
      Optional.Absent,
    thingGroupMetadata: Optional[zio.aws.iot.model.ThingGroupMetadata] =
      Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: Optional[QueryString] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent,
    status: Optional[zio.aws.iot.model.DynamicGroupStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse = {
    import DescribeThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(thingGroupProperties.map(value => value.buildAwsValue()))(
        _.thingGroupProperties
      )
      .optionallyWith(thingGroupMetadata.map(value => value.buildAwsValue()))(
        _.thingGroupMetadata
      )
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly =
    zio.aws.iot.model.DescribeThingGroupResponse.wrap(buildAwsValue())
}
object DescribeThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingGroupResponse =
      zio.aws.iot.model.DescribeThingGroupResponse(
        thingGroupName.map(value => value),
        thingGroupId.map(value => value),
        thingGroupArn.map(value => value),
        version.map(value => value),
        thingGroupProperties.map(value => value.asEditable),
        thingGroupMetadata.map(value => value.asEditable),
        indexName.map(value => value),
        queryString.map(value => value),
        queryVersion.map(value => value),
        status.map(value => value)
      )
    def thingGroupName: Optional[ThingGroupName]
    def thingGroupId: Optional[ThingGroupId]
    def thingGroupArn: Optional[ThingGroupArn]
    def version: Optional[Version]
    def thingGroupProperties
        : Optional[zio.aws.iot.model.ThingGroupProperties.ReadOnly]
    def thingGroupMetadata
        : Optional[zio.aws.iot.model.ThingGroupMetadata.ReadOnly]
    def indexName: Optional[IndexName]
    def queryString: Optional[QueryString]
    def queryVersion: Optional[QueryVersion]
    def status: Optional[zio.aws.iot.model.DynamicGroupStatus]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getThingGroupProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingGroupProperties", thingGroupProperties)
    def getThingGroupMetadata
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingGroupMetadata.ReadOnly] =
      AwsError.unwrapOptionField("thingGroupMetadata", thingGroupMetadata)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.DynamicGroupStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
  ) extends zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly {
    override val thingGroupName: Optional[ThingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupName())
        .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupId: Optional[ThingGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val thingGroupArn: Optional[ThingGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val thingGroupProperties
        : Optional[zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupProperties())
        .map(value => zio.aws.iot.model.ThingGroupProperties.wrap(value))
    override val thingGroupMetadata
        : Optional[zio.aws.iot.model.ThingGroupMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupMetadata())
        .map(value => zio.aws.iot.model.ThingGroupMetadata.wrap(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val status: Optional[zio.aws.iot.model.DynamicGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.DynamicGroupStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
  ): zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly = new Wrapper(impl)
}
