package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  PrimitiveBoolean,
  Timestamp,
  MitigationActionsTaskId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DetectMitigationActionsTaskSummary(
    taskId: Optional[MitigationActionsTaskId] = Optional.Absent,
    taskStatus: Optional[zio.aws.iot.model.DetectMitigationActionsTaskStatus] =
      Optional.Absent,
    taskStartTime: Optional[Timestamp] = Optional.Absent,
    taskEndTime: Optional[Timestamp] = Optional.Absent,
    target: Optional[zio.aws.iot.model.DetectMitigationActionsTaskTarget] =
      Optional.Absent,
    violationEventOccurrenceRange: Optional[
      zio.aws.iot.model.ViolationEventOccurrenceRange
    ] = Optional.Absent,
    onlyActiveViolationsIncluded: Optional[PrimitiveBoolean] = Optional.Absent,
    suppressedAlertsIncluded: Optional[PrimitiveBoolean] = Optional.Absent,
    actionsDefinition: Optional[Iterable[zio.aws.iot.model.MitigationAction]] =
      Optional.Absent,
    taskStatistics: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary = {
    import DetectMitigationActionsTaskSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        taskStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(
        taskEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskEndTime)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        violationEventOccurrenceRange.map(value => value.buildAwsValue())
      )(_.violationEventOccurrenceRange)
      .optionallyWith(
        onlyActiveViolationsIncluded.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.onlyActiveViolationsIncluded)
      .optionallyWith(
        suppressedAlertsIncluded.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.suppressedAlertsIncluded)
      .optionallyWith(
        actionsDefinition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsDefinition)
      .optionallyWith(taskStatistics.map(value => value.buildAwsValue()))(
        _.taskStatistics
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly =
    zio.aws.iot.model.DetectMitigationActionsTaskSummary.wrap(buildAwsValue())
}
object DetectMitigationActionsTaskSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetectMitigationActionsTaskSummary =
      zio.aws.iot.model.DetectMitigationActionsTaskSummary(
        taskId.map(value => value),
        taskStatus.map(value => value),
        taskStartTime.map(value => value),
        taskEndTime.map(value => value),
        target.map(value => value.asEditable),
        violationEventOccurrenceRange.map(value => value.asEditable),
        onlyActiveViolationsIncluded.map(value => value),
        suppressedAlertsIncluded.map(value => value),
        actionsDefinition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskStatistics.map(value => value.asEditable)
      )
    def taskId: Optional[MitigationActionsTaskId]
    def taskStatus
        : Optional[zio.aws.iot.model.DetectMitigationActionsTaskStatus]
    def taskStartTime: Optional[Timestamp]
    def taskEndTime: Optional[Timestamp]
    def target
        : Optional[zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly]
    def violationEventOccurrenceRange
        : Optional[zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly]
    def onlyActiveViolationsIncluded: Optional[PrimitiveBoolean]
    def suppressedAlertsIncluded: Optional[PrimitiveBoolean]
    def actionsDefinition
        : Optional[List[zio.aws.iot.model.MitigationAction.ReadOnly]]
    def taskStatistics: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly
    ]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskStatus
    ] = AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getTaskEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskEndTime", taskEndTime)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getViolationEventOccurrenceRange: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "violationEventOccurrenceRange",
      violationEventOccurrenceRange
    )
    def getOnlyActiveViolationsIncluded: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "onlyActiveViolationsIncluded",
        onlyActiveViolationsIncluded
      )
    def getSuppressedAlertsIncluded: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "suppressedAlertsIncluded",
        suppressedAlertsIncluded
      )
    def getActionsDefinition: ZIO[Any, AwsError, List[
      zio.aws.iot.model.MitigationAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsDefinition", actionsDefinition)
    def getTaskStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("taskStatistics", taskStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
  ) extends zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly {
    override val taskId: Optional[MitigationActionsTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskId())
        .map(value =>
          zio.aws.iot.model.primitives.MitigationActionsTaskId(value)
        )
    override val taskStatus
        : Optional[zio.aws.iot.model.DetectMitigationActionsTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value =>
          zio.aws.iot.model.DetectMitigationActionsTaskStatus.wrap(value)
        )
    override val taskStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskEndTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val target: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value =>
        zio.aws.iot.model.DetectMitigationActionsTaskTarget.wrap(value)
      )
    override val violationEventOccurrenceRange
        : Optional[zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationEventOccurrenceRange())
        .map(value =>
          zio.aws.iot.model.ViolationEventOccurrenceRange.wrap(value)
        )
    override val onlyActiveViolationsIncluded: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlyActiveViolationsIncluded())
        .map(value => zio.aws.iot.model.primitives.PrimitiveBoolean(value))
    override val suppressedAlertsIncluded: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressedAlertsIncluded())
        .map(value => zio.aws.iot.model.primitives.PrimitiveBoolean(value))
    override val actionsDefinition
        : Optional[List[zio.aws.iot.model.MitigationAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsDefinition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MitigationAction.wrap(item)
          }.toList
        )
    override val taskStatistics: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskStatistics())
      .map(value =>
        zio.aws.iot.model.DetectMitigationActionsTaskStatistics.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
  ): zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly =
    new Wrapper(impl)
}
