package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ElasticsearchType,
  ElasticsearchIndex,
  ElasticsearchId,
  AwsArn,
  ElasticsearchEndpoint
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ElasticsearchAction(
    roleArn: AwsArn,
    endpoint: ElasticsearchEndpoint,
    index: ElasticsearchIndex,
    `type`: ElasticsearchType,
    id: ElasticsearchId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ElasticsearchAction = {
    import ElasticsearchAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ElasticsearchAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .endpoint(ElasticsearchEndpoint.unwrap(endpoint): java.lang.String)
      .index(ElasticsearchIndex.unwrap(index): java.lang.String)
      .`type`(ElasticsearchType.unwrap(`type`): java.lang.String)
      .id(ElasticsearchId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ElasticsearchAction.ReadOnly =
    zio.aws.iot.model.ElasticsearchAction.wrap(buildAwsValue())
}
object ElasticsearchAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ElasticsearchAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ElasticsearchAction = zio.aws.iot.model
      .ElasticsearchAction(roleArn, endpoint, index, `type`, id)
    def roleArn: AwsArn
    def endpoint: ElasticsearchEndpoint
    def index: ElasticsearchIndex
    def `type`: ElasticsearchType
    def id: ElasticsearchId
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getEndpoint: ZIO[Any, Nothing, ElasticsearchEndpoint] =
      ZIO.succeed(endpoint)
    def getIndex: ZIO[Any, Nothing, ElasticsearchIndex] = ZIO.succeed(index)
    def getType: ZIO[Any, Nothing, ElasticsearchType] = ZIO.succeed(`type`)
    def getId: ZIO[Any, Nothing, ElasticsearchId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ElasticsearchAction
  ) extends zio.aws.iot.model.ElasticsearchAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val endpoint: ElasticsearchEndpoint =
      zio.aws.iot.model.primitives.ElasticsearchEndpoint(impl.endpoint())
    override val index: ElasticsearchIndex =
      zio.aws.iot.model.primitives.ElasticsearchIndex(impl.index())
    override val `type`: ElasticsearchType =
      zio.aws.iot.model.primitives.ElasticsearchType(impl.`type`())
    override val id: ElasticsearchId =
      zio.aws.iot.model.primitives.ElasticsearchId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ElasticsearchAction
  ): zio.aws.iot.model.ElasticsearchAction.ReadOnly = new Wrapper(impl)
}
