package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  BatchMode,
  FirehoseSeparator,
  DeliveryStreamName,
  AwsArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FirehoseAction(
    roleArn: AwsArn,
    deliveryStreamName: DeliveryStreamName,
    separator: Optional[FirehoseSeparator] = Optional.Absent,
    batchMode: Optional[BatchMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.FirehoseAction = {
    import FirehoseAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.FirehoseAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .optionallyWith(
        separator.map(value =>
          FirehoseSeparator.unwrap(value): java.lang.String
        )
      )(_.separator)
      .optionallyWith(
        batchMode.map(value => BatchMode.unwrap(value): java.lang.Boolean)
      )(_.batchMode)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.FirehoseAction.ReadOnly =
    zio.aws.iot.model.FirehoseAction.wrap(buildAwsValue())
}
object FirehoseAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.FirehoseAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.FirehoseAction =
      zio.aws.iot.model.FirehoseAction(
        roleArn,
        deliveryStreamName,
        separator.map(value => value),
        batchMode.map(value => value)
      )
    def roleArn: AwsArn
    def deliveryStreamName: DeliveryStreamName
    def separator: Optional[FirehoseSeparator]
    def batchMode: Optional[BatchMode]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getSeparator: ZIO[Any, AwsError, FirehoseSeparator] =
      AwsError.unwrapOptionField("separator", separator)
    def getBatchMode: ZIO[Any, AwsError, BatchMode] =
      AwsError.unwrapOptionField("batchMode", batchMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.FirehoseAction
  ) extends zio.aws.iot.model.FirehoseAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.iot.model.primitives.DeliveryStreamName(impl.deliveryStreamName())
    override val separator: Optional[FirehoseSeparator] = zio.aws.core.internal
      .optionalFromNullable(impl.separator())
      .map(value => zio.aws.iot.model.primitives.FirehoseSeparator(value))
    override val batchMode: Optional[BatchMode] = zio.aws.core.internal
      .optionalFromNullable(impl.batchMode())
      .map(value => zio.aws.iot.model.primitives.BatchMode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.FirehoseAction
  ): zio.aws.iot.model.FirehoseAction.ReadOnly = new Wrapper(impl)
}
