package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait FleetMetricUnit {
  def unwrap: software.amazon.awssdk.services.iot.model.FleetMetricUnit
}
object FleetMetricUnit {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.FleetMetricUnit
  ): zio.aws.iot.model.FleetMetricUnit = value match {
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.SECONDS =>
      val r = Seconds
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.MICROSECONDS =>
      val r = Microseconds
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.MILLISECONDS =>
      val r = Milliseconds
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.BYTES =>
      val r = Bytes
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBYTES =>
      val r = Kilobytes
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABYTES =>
      val r = Megabytes
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABYTES =>
      val r = Gigabytes
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABYTES =>
      val r = Terabytes
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.BITS =>
      val r = Bits
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBITS =>
      val r = Kilobits
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABITS =>
      val r = Megabits
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABITS =>
      val r = Gigabits
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABITS =>
      val r = Terabits
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.PERCENT =>
      val r = Percent
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.COUNT =>
      val r = Count
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.BYTES_SECOND =>
      val r = `Bytes/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBYTES_SECOND =>
      val r = `Kilobytes/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABYTES_SECOND =>
      val r = `Megabytes/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABYTES_SECOND =>
      val r = `Gigabytes/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABYTES_SECOND =>
      val r = `Terabytes/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.BITS_SECOND =>
      val r = `Bits/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBITS_SECOND =>
      val r = `Kilobits/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABITS_SECOND =>
      val r = `Megabits/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABITS_SECOND =>
      val r = `Gigabits/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABITS_SECOND =>
      val r = `Terabits/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.COUNT_SECOND =>
      val r = `Count/Second`
      r
    case software.amazon.awssdk.services.iot.model.FleetMetricUnit.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Seconds extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.SECONDS
  }
  case object Microseconds extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.MICROSECONDS
  }
  case object Milliseconds extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.MILLISECONDS
  }
  case object Bytes extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.BYTES
  }
  case object Kilobytes extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBYTES
  }
  case object Megabytes extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABYTES
  }
  case object Gigabytes extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABYTES
  }
  case object Terabytes extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABYTES
  }
  case object Bits extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.BITS
  }
  case object Kilobits extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBITS
  }
  case object Megabits extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABITS
  }
  case object Gigabits extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABITS
  }
  case object Terabits extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABITS
  }
  case object Percent extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.PERCENT
  }
  case object Count extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.COUNT
  }
  case object `Bytes/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.BYTES_SECOND
  }
  case object `Kilobytes/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBYTES_SECOND
  }
  case object `Megabytes/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABYTES_SECOND
  }
  case object `Gigabytes/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABYTES_SECOND
  }
  case object `Terabytes/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABYTES_SECOND
  }
  case object `Bits/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.BITS_SECOND
  }
  case object `Kilobits/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.KILOBITS_SECOND
  }
  case object `Megabits/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.MEGABITS_SECOND
  }
  case object `Gigabits/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.GIGABITS_SECOND
  }
  case object `Terabits/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.TERABITS_SECOND
  }
  case object `Count/Second` extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.COUNT_SECOND
  }
  case object None extends zio.aws.iot.model.FleetMetricUnit {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.FleetMetricUnit =
      software.amazon.awssdk.services.iot.model.FleetMetricUnit.NONE
  }
}
