package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetIndexingConfigurationResponse(
    thingIndexingConfiguration: Optional[
      zio.aws.iot.model.ThingIndexingConfiguration
    ] = Optional.Absent,
    thingGroupIndexingConfiguration: Optional[
      zio.aws.iot.model.ThingGroupIndexingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse = {
    import GetIndexingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse
      .builder()
      .optionallyWith(
        thingIndexingConfiguration.map(value => value.buildAwsValue())
      )(_.thingIndexingConfiguration)
      .optionallyWith(
        thingGroupIndexingConfiguration.map(value => value.buildAwsValue())
      )(_.thingGroupIndexingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly =
    zio.aws.iot.model.GetIndexingConfigurationResponse.wrap(buildAwsValue())
}
object GetIndexingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetIndexingConfigurationResponse =
      zio.aws.iot.model.GetIndexingConfigurationResponse(
        thingIndexingConfiguration.map(value => value.asEditable),
        thingGroupIndexingConfiguration.map(value => value.asEditable)
      )
    def thingIndexingConfiguration
        : Optional[zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly]
    def thingGroupIndexingConfiguration
        : Optional[zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly]
    def getThingIndexingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thingIndexingConfiguration",
      thingIndexingConfiguration
    )
    def getThingGroupIndexingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thingGroupIndexingConfiguration",
      thingGroupIndexingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse
  ) extends zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly {
    override val thingIndexingConfiguration
        : Optional[zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingIndexingConfiguration())
        .map(value => zio.aws.iot.model.ThingIndexingConfiguration.wrap(value))
    override val thingGroupIndexingConfiguration
        : Optional[zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupIndexingConfiguration())
        .map(value =>
          zio.aws.iot.model.ThingGroupIndexingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse
  ): zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
