package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLoggingOptionsResponse(
    roleArn: Optional[AwsArn] = Optional.Absent,
    logLevel: Optional[zio.aws.iot.model.LogLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse = {
    import GetLoggingOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
      .builder()
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly =
    zio.aws.iot.model.GetLoggingOptionsResponse.wrap(buildAwsValue())
}
object GetLoggingOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetLoggingOptionsResponse =
      zio.aws.iot.model.GetLoggingOptionsResponse(
        roleArn.map(value => value),
        logLevel.map(value => value)
      )
    def roleArn: Optional[AwsArn]
    def logLevel: Optional[zio.aws.iot.model.LogLevel]
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.iot.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
  ) extends zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly {
    override val roleArn: Optional[AwsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val logLevel: Optional[zio.aws.iot.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.iot.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
  ): zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly = new Wrapper(impl)
}
