package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Percent,
  IndexName,
  AggregationField,
  QueryVersion,
  QueryString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPercentilesRequest(
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: QueryString,
    aggregationField: Optional[AggregationField] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent,
    percents: Optional[Iterable[Percent]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPercentilesRequest = {
    import GetPercentilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPercentilesRequest
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(
        percents.map(value =>
          value.map { item =>
            Percent.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.percents)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPercentilesRequest.ReadOnly =
    zio.aws.iot.model.GetPercentilesRequest.wrap(buildAwsValue())
}
object GetPercentilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPercentilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPercentilesRequest =
      zio.aws.iot.model.GetPercentilesRequest(
        indexName.map(value => value),
        queryString,
        aggregationField.map(value => value),
        queryVersion.map(value => value),
        percents.map(value => value)
      )
    def indexName: Optional[IndexName]
    def queryString: QueryString
    def aggregationField: Optional[AggregationField]
    def queryVersion: Optional[QueryVersion]
    def percents: Optional[List[Percent]]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getPercents: ZIO[Any, AwsError, List[Percent]] =
      AwsError.unwrapOptionField("percents", percents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPercentilesRequest
  ) extends zio.aws.iot.model.GetPercentilesRequest.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val aggregationField: Optional[AggregationField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationField())
        .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val percents: Optional[List[Percent]] = zio.aws.core.internal
      .optionalFromNullable(impl.percents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Percent(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPercentilesRequest
  ): zio.aws.iot.model.GetPercentilesRequest.ReadOnly = new Wrapper(impl)
}
