package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  PolicyArn,
  PolicyName,
  DateType,
  IsDefaultVersion,
  PolicyVersionId,
  PolicyDocument,
  GenerationId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetPolicyVersionResponse(
    policyArn: Optional[PolicyArn] = Optional.Absent,
    policyName: Optional[PolicyName] = Optional.Absent,
    policyDocument: Optional[PolicyDocument] = Optional.Absent,
    policyVersionId: Optional[PolicyVersionId] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    generationId: Optional[GenerationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse = {
    import GetPolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
      .builder()
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly =
    zio.aws.iot.model.GetPolicyVersionResponse.wrap(buildAwsValue())
}
object GetPolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPolicyVersionResponse =
      zio.aws.iot.model.GetPolicyVersionResponse(
        policyArn.map(value => value),
        policyName.map(value => value),
        policyDocument.map(value => value),
        policyVersionId.map(value => value),
        isDefaultVersion.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        generationId.map(value => value)
      )
    def policyArn: Optional[PolicyArn]
    def policyName: Optional[PolicyName]
    def policyDocument: Optional[PolicyDocument]
    def policyVersionId: Optional[PolicyVersionId]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def generationId: Optional[GenerationId]
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
  ) extends zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly {
    override val policyArn: Optional[PolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyDocument: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val policyVersionId: Optional[PolicyVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyVersionId())
        .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val generationId: Optional[GenerationId] = zio.aws.core.internal
      .optionalFromNullable(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
  ): zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly = new Wrapper(impl)
}
