package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImplicitDeny(
    policies: Optional[Iterable[zio.aws.iot.model.Policy]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ImplicitDeny = {
    import ImplicitDeny.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ImplicitDeny
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ImplicitDeny.ReadOnly =
    zio.aws.iot.model.ImplicitDeny.wrap(buildAwsValue())
}
object ImplicitDeny {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.ImplicitDeny] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ImplicitDeny =
      zio.aws.iot.model.ImplicitDeny(
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policies: Optional[List[zio.aws.iot.model.Policy.ReadOnly]]
    def getPolicies
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Policy.ReadOnly]] =
      AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ImplicitDeny
  ) extends zio.aws.iot.model.ImplicitDeny.ReadOnly {
    override val policies: Optional[List[zio.aws.iot.model.Policy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Policy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ImplicitDeny
  ): zio.aws.iot.model.ImplicitDeny.ReadOnly = new Wrapper(impl)
}
