package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ShadowName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IndexingFilter(
    namedShadowNames: Optional[Iterable[ShadowName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.IndexingFilter = {
    import IndexingFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.IndexingFilter
      .builder()
      .optionallyWith(
        namedShadowNames.map(value =>
          value.map { item =>
            ShadowName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.namedShadowNames)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.IndexingFilter.ReadOnly =
    zio.aws.iot.model.IndexingFilter.wrap(buildAwsValue())
}
object IndexingFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.IndexingFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.IndexingFilter =
      zio.aws.iot.model.IndexingFilter(namedShadowNames.map(value => value))
    def namedShadowNames: Optional[List[ShadowName]]
    def getNamedShadowNames: ZIO[Any, AwsError, List[ShadowName]] =
      AwsError.unwrapOptionField("namedShadowNames", namedShadowNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.IndexingFilter
  ) extends zio.aws.iot.model.IndexingFilter.ReadOnly {
    override val namedShadowNames: Optional[List[ShadowName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namedShadowNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.ShadowName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.IndexingFilter
  ): zio.aws.iot.model.IndexingFilter.ReadOnly = new Wrapper(impl)
}
