package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IssuerCertificateSerialNumber,
  IssuerId,
  IssuerCertificateSubject
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IssuerCertificateIdentifier(
    issuerCertificateSubject: Optional[IssuerCertificateSubject] =
      Optional.Absent,
    issuerId: Optional[IssuerId] = Optional.Absent,
    issuerCertificateSerialNumber: Optional[IssuerCertificateSerialNumber] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.IssuerCertificateIdentifier = {
    import IssuerCertificateIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.IssuerCertificateIdentifier
      .builder()
      .optionallyWith(
        issuerCertificateSubject.map(value =>
          IssuerCertificateSubject.unwrap(value): java.lang.String
        )
      )(_.issuerCertificateSubject)
      .optionallyWith(
        issuerId.map(value => IssuerId.unwrap(value): java.lang.String)
      )(_.issuerId)
      .optionallyWith(
        issuerCertificateSerialNumber.map(value =>
          IssuerCertificateSerialNumber.unwrap(value): java.lang.String
        )
      )(_.issuerCertificateSerialNumber)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.IssuerCertificateIdentifier.ReadOnly =
    zio.aws.iot.model.IssuerCertificateIdentifier.wrap(buildAwsValue())
}
object IssuerCertificateIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.IssuerCertificateIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.IssuerCertificateIdentifier =
      zio.aws.iot.model.IssuerCertificateIdentifier(
        issuerCertificateSubject.map(value => value),
        issuerId.map(value => value),
        issuerCertificateSerialNumber.map(value => value)
      )
    def issuerCertificateSubject: Optional[IssuerCertificateSubject]
    def issuerId: Optional[IssuerId]
    def issuerCertificateSerialNumber: Optional[IssuerCertificateSerialNumber]
    def getIssuerCertificateSubject
        : ZIO[Any, AwsError, IssuerCertificateSubject] = AwsError
      .unwrapOptionField("issuerCertificateSubject", issuerCertificateSubject)
    def getIssuerId: ZIO[Any, AwsError, IssuerId] =
      AwsError.unwrapOptionField("issuerId", issuerId)
    def getIssuerCertificateSerialNumber
        : ZIO[Any, AwsError, IssuerCertificateSerialNumber] =
      AwsError.unwrapOptionField(
        "issuerCertificateSerialNumber",
        issuerCertificateSerialNumber
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.IssuerCertificateIdentifier
  ) extends zio.aws.iot.model.IssuerCertificateIdentifier.ReadOnly {
    override val issuerCertificateSubject: Optional[IssuerCertificateSubject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issuerCertificateSubject())
        .map(value =>
          zio.aws.iot.model.primitives.IssuerCertificateSubject(value)
        )
    override val issuerId: Optional[IssuerId] = zio.aws.core.internal
      .optionalFromNullable(impl.issuerId())
      .map(value => zio.aws.iot.model.primitives.IssuerId(value))
    override val issuerCertificateSerialNumber
        : Optional[IssuerCertificateSerialNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.issuerCertificateSerialNumber())
      .map(value =>
        zio.aws.iot.model.primitives.IssuerCertificateSerialNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.IssuerCertificateIdentifier
  ): zio.aws.iot.model.IssuerCertificateIdentifier.ReadOnly = new Wrapper(impl)
}
