package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait JobEndBehavior {
  def unwrap: software.amazon.awssdk.services.iot.model.JobEndBehavior
}
object JobEndBehavior {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.JobEndBehavior
  ): zio.aws.iot.model.JobEndBehavior = value match {
    case software.amazon.awssdk.services.iot.model.JobEndBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.JobEndBehavior.STOP_ROLLOUT =>
      val r = STOP_ROLLOUT
      r
    case software.amazon.awssdk.services.iot.model.JobEndBehavior.CANCEL =>
      val r = CANCEL
      r
    case software.amazon.awssdk.services.iot.model.JobEndBehavior.FORCE_CANCEL =>
      val r = FORCE_CANCEL
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.JobEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobEndBehavior =
      software.amazon.awssdk.services.iot.model.JobEndBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object STOP_ROLLOUT extends zio.aws.iot.model.JobEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobEndBehavior =
      software.amazon.awssdk.services.iot.model.JobEndBehavior.STOP_ROLLOUT
  }
  case object CANCEL extends zio.aws.iot.model.JobEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobEndBehavior =
      software.amazon.awssdk.services.iot.model.JobEndBehavior.CANCEL
  }
  case object FORCE_CANCEL extends zio.aws.iot.model.JobEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobEndBehavior =
      software.amazon.awssdk.services.iot.model.JobEndBehavior.FORCE_CANCEL
  }
}
