package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobTemplatesResponse(
    jobTemplates: Optional[Iterable[zio.aws.iot.model.JobTemplateSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse = {
    import ListJobTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse
      .builder()
      .optionallyWith(
        jobTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly =
    zio.aws.iot.model.ListJobTemplatesResponse.wrap(buildAwsValue())
}
object ListJobTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobTemplatesResponse =
      zio.aws.iot.model.ListJobTemplatesResponse(
        jobTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobTemplates
        : Optional[List[zio.aws.iot.model.JobTemplateSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getJobTemplates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.JobTemplateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("jobTemplates", jobTemplates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse
  ) extends zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly {
    override val jobTemplates
        : Optional[List[zio.aws.iot.model.JobTemplateSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTemplates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.JobTemplateSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse
  ): zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly = new Wrapper(impl)
}
