package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobsResponse(
    jobs: Optional[Iterable[zio.aws.iot.model.JobSummary]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobsResponse.ReadOnly =
    zio.aws.iot.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobsResponse =
      zio.aws.iot.model.ListJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobs: Optional[List[zio.aws.iot.model.JobSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getJobs
        : ZIO[Any, AwsError, List[zio.aws.iot.model.JobSummary.ReadOnly]] =
      AwsError.unwrapOptionField("jobs", jobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobsResponse
  ) extends zio.aws.iot.model.ListJobsResponse.ReadOnly {
    override val jobs: Optional[List[zio.aws.iot.model.JobSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.JobSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobsResponse
  ): zio.aws.iot.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
