package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{NextToken, MaxResults, TemplateName}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListProvisioningTemplateVersionsRequest(
    templateName: TemplateName,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest = {
    import ListProvisioningTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListProvisioningTemplateVersionsRequest.ReadOnly =
    zio.aws.iot.model.ListProvisioningTemplateVersionsRequest
      .wrap(buildAwsValue())
}
object ListProvisioningTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListProvisioningTemplateVersionsRequest =
      zio.aws.iot.model.ListProvisioningTemplateVersionsRequest(
        templateName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def templateName: TemplateName
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest
  ) extends zio.aws.iot.model.ListProvisioningTemplateVersionsRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest
  ): zio.aws.iot.model.ListProvisioningTemplateVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
