package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{MaxResults, NextToken, FindingId}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRelatedResourcesForAuditFindingRequest(
    findingId: FindingId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest = {
    import ListRelatedResourcesForAuditFindingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest
      .builder()
      .findingId(FindingId.unwrap(findingId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListRelatedResourcesForAuditFindingRequest.ReadOnly =
    zio.aws.iot.model.ListRelatedResourcesForAuditFindingRequest
      .wrap(buildAwsValue())
}
object ListRelatedResourcesForAuditFindingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListRelatedResourcesForAuditFindingRequest =
      zio.aws.iot.model.ListRelatedResourcesForAuditFindingRequest(
        findingId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def findingId: FindingId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFindingId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(findingId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest
  ) extends zio.aws.iot.model.ListRelatedResourcesForAuditFindingRequest.ReadOnly {
    override val findingId: FindingId =
      zio.aws.iot.model.primitives.FindingId(impl.findingId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest
  ): zio.aws.iot.model.ListRelatedResourcesForAuditFindingRequest.ReadOnly =
    new Wrapper(impl)
}
