package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RecursiveWithoutDefault,
  ThingGroupName,
  RegistryMaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListThingGroupsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent,
    parentGroup: Optional[ThingGroupName] = Optional.Absent,
    namePrefixFilter: Optional[ThingGroupName] = Optional.Absent,
    recursive: Optional[RecursiveWithoutDefault] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingGroupsRequest = {
    import ListThingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        parentGroup.map(value => ThingGroupName.unwrap(value): java.lang.String)
      )(_.parentGroup)
      .optionallyWith(
        namePrefixFilter.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.namePrefixFilter)
      .optionallyWith(
        recursive.map(value =>
          RecursiveWithoutDefault.unwrap(value): java.lang.Boolean
        )
      )(_.recursive)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingGroupsRequest.ReadOnly =
    zio.aws.iot.model.ListThingGroupsRequest.wrap(buildAwsValue())
}
object ListThingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingGroupsRequest =
      zio.aws.iot.model.ListThingGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        parentGroup.map(value => value),
        namePrefixFilter.map(value => value),
        recursive.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def parentGroup: Optional[ThingGroupName]
    def namePrefixFilter: Optional[ThingGroupName]
    def recursive: Optional[RecursiveWithoutDefault]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getParentGroup: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("parentGroup", parentGroup)
    def getNamePrefixFilter: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("namePrefixFilter", namePrefixFilter)
    def getRecursive: ZIO[Any, AwsError, RecursiveWithoutDefault] =
      AwsError.unwrapOptionField("recursive", recursive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
  ) extends zio.aws.iot.model.ListThingGroupsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val parentGroup: Optional[ThingGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.parentGroup())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val namePrefixFilter: Optional[ThingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namePrefixFilter())
        .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val recursive: Optional[RecursiveWithoutDefault] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recursive())
        .map(value =>
          zio.aws.iot.model.primitives.RecursiveWithoutDefault(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
  ): zio.aws.iot.model.ListThingGroupsRequest.ReadOnly = new Wrapper(impl)
}
