package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ThingTypeName,
  NextToken,
  AttributeName,
  UsePrefixAttributeValue,
  RegistryMaxResults,
  AttributeValue
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListThingsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent,
    attributeName: Optional[AttributeName] = Optional.Absent,
    attributeValue: Optional[AttributeValue] = Optional.Absent,
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    usePrefixAttributeValue: Optional[UsePrefixAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingsRequest = {
    import ListThingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        attributeName.map(value =>
          AttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        attributeValue.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.attributeValue)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        usePrefixAttributeValue.map(value =>
          UsePrefixAttributeValue.unwrap(value): java.lang.Boolean
        )
      )(_.usePrefixAttributeValue)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingsRequest.ReadOnly =
    zio.aws.iot.model.ListThingsRequest.wrap(buildAwsValue())
}
object ListThingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingsRequest =
      zio.aws.iot.model.ListThingsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        attributeName.map(value => value),
        attributeValue.map(value => value),
        thingTypeName.map(value => value),
        usePrefixAttributeValue.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def attributeName: Optional[AttributeName]
    def attributeValue: Optional[AttributeValue]
    def thingTypeName: Optional[ThingTypeName]
    def usePrefixAttributeValue: Optional[UsePrefixAttributeValue]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAttributeName: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getUsePrefixAttributeValue
        : ZIO[Any, AwsError, UsePrefixAttributeValue] = AwsError
      .unwrapOptionField("usePrefixAttributeValue", usePrefixAttributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingsRequest
  ) extends zio.aws.iot.model.ListThingsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val attributeName: Optional[AttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => zio.aws.iot.model.primitives.AttributeName(value))
    override val attributeValue: Optional[AttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeValue())
        .map(value => zio.aws.iot.model.primitives.AttributeValue(value))
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val usePrefixAttributeValue: Optional[UsePrefixAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usePrefixAttributeValue())
        .map(value =>
          zio.aws.iot.model.primitives.UsePrefixAttributeValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingsRequest
  ): zio.aws.iot.model.ListThingsRequest.ReadOnly = new Wrapper(impl)
}
