package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LocationAction(
    roleArn: AwsArn,
    trackerName: String,
    deviceId: String,
    timestamp: Optional[zio.aws.iot.model.LocationTimestamp] = Optional.Absent,
    latitude: String,
    longitude: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.LocationAction = {
    import LocationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.LocationAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .trackerName(trackerName: java.lang.String)
      .deviceId(deviceId: java.lang.String)
      .optionallyWith(timestamp.map(value => value.buildAwsValue()))(
        _.timestamp
      )
      .latitude(latitude: java.lang.String)
      .longitude(longitude: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.LocationAction.ReadOnly =
    zio.aws.iot.model.LocationAction.wrap(buildAwsValue())
}
object LocationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.LocationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.LocationAction =
      zio.aws.iot.model.LocationAction(
        roleArn,
        trackerName,
        deviceId,
        timestamp.map(value => value.asEditable),
        latitude,
        longitude
      )
    def roleArn: AwsArn
    def trackerName: String
    def deviceId: String
    def timestamp: Optional[zio.aws.iot.model.LocationTimestamp.ReadOnly]
    def latitude: String
    def longitude: String
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getTrackerName: ZIO[Any, Nothing, String] = ZIO.succeed(trackerName)
    def getDeviceId: ZIO[Any, Nothing, String] = ZIO.succeed(deviceId)
    def getTimestamp
        : ZIO[Any, AwsError, zio.aws.iot.model.LocationTimestamp.ReadOnly] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getLatitude: ZIO[Any, Nothing, String] = ZIO.succeed(latitude)
    def getLongitude: ZIO[Any, Nothing, String] = ZIO.succeed(longitude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.LocationAction
  ) extends zio.aws.iot.model.LocationAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val trackerName: String = impl.trackerName(): String
    override val deviceId: String = impl.deviceId(): String
    override val timestamp
        : Optional[zio.aws.iot.model.LocationTimestamp.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestamp())
        .map(value => zio.aws.iot.model.LocationTimestamp.wrap(value))
    override val latitude: String = impl.latitude(): String
    override val longitude: String = impl.longitude(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.LocationAction
  ): zio.aws.iot.model.LocationAction.ReadOnly = new Wrapper(impl)
}
