package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LocationTimestamp(
    value: String,
    unit: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.LocationTimestamp = {
    import LocationTimestamp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.LocationTimestamp
      .builder()
      .value(value: java.lang.String)
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.LocationTimestamp.ReadOnly =
    zio.aws.iot.model.LocationTimestamp.wrap(buildAwsValue())
}
object LocationTimestamp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.LocationTimestamp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.LocationTimestamp =
      zio.aws.iot.model.LocationTimestamp(value, unit.map(value => value))
    def value: String
    def unit: Optional[String]
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
    def getUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.LocationTimestamp
  ) extends zio.aws.iot.model.LocationTimestamp.ReadOnly {
    override val value: String = impl.value(): String
    override val unit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.LocationTimestamp
  ): zio.aws.iot.model.LocationTimestamp.ReadOnly = new Wrapper(impl)
}
