package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  UnsignedLong,
  Cidr,
  Port,
  Number,
  StringValue
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MetricValue(
    count: Optional[UnsignedLong] = Optional.Absent,
    cidrs: Optional[Iterable[Cidr]] = Optional.Absent,
    ports: Optional[Iterable[Port]] = Optional.Absent,
    number: Optional[Number] = Optional.Absent,
    numbers: Optional[Iterable[Number]] = Optional.Absent,
    strings: Optional[Iterable[StringValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.MetricValue = {
    import MetricValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MetricValue
      .builder()
      .optionallyWith(
        count.map(value => UnsignedLong.unwrap(value): java.lang.Long)
      )(_.count)
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            Cidr.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ports.map(value =>
          value.map { item =>
            Port.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.ports)
      .optionallyWith(
        number.map(value => Number.unwrap(value): java.lang.Double)
      )(_.number)
      .optionallyWith(
        numbers.map(value =>
          value.map { item =>
            Number.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.numbers)
      .optionallyWith(
        strings.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.strings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MetricValue.ReadOnly =
    zio.aws.iot.model.MetricValue.wrap(buildAwsValue())
}
object MetricValue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.MetricValue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MetricValue =
      zio.aws.iot.model.MetricValue(
        count.map(value => value),
        cidrs.map(value => value),
        ports.map(value => value),
        number.map(value => value),
        numbers.map(value => value),
        strings.map(value => value)
      )
    def count: Optional[UnsignedLong]
    def cidrs: Optional[List[Cidr]]
    def ports: Optional[List[Port]]
    def number: Optional[Number]
    def numbers: Optional[List[Number]]
    def strings: Optional[List[StringValue]]
    def getCount: ZIO[Any, AwsError, UnsignedLong] =
      AwsError.unwrapOptionField("count", count)
    def getCidrs: ZIO[Any, AwsError, List[Cidr]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getPorts: ZIO[Any, AwsError, List[Port]] =
      AwsError.unwrapOptionField("ports", ports)
    def getNumber: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("number", number)
    def getNumbers: ZIO[Any, AwsError, List[Number]] =
      AwsError.unwrapOptionField("numbers", numbers)
    def getStrings: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("strings", strings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MetricValue
  ) extends zio.aws.iot.model.MetricValue.ReadOnly {
    override val count: Optional[UnsignedLong] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.iot.model.primitives.UnsignedLong(value))
    override val cidrs: Optional[List[Cidr]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Cidr(item)
        }.toList
      )
    override val ports: Optional[List[Port]] = zio.aws.core.internal
      .optionalFromNullable(impl.ports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Port(item)
        }.toList
      )
    override val number: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.number())
      .map(value => zio.aws.iot.model.primitives.Number(value))
    override val numbers: Optional[List[Number]] = zio.aws.core.internal
      .optionalFromNullable(impl.numbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Number(item)
        }.toList
      )
    override val strings: Optional[List[StringValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.strings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.StringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MetricValue
  ): zio.aws.iot.model.MetricValue.ReadOnly = new Wrapper(impl)
}
