package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  Timestamp,
  MitigationActionArn,
  MitigationActionName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MitigationActionIdentifier(
    actionName: Optional[MitigationActionName] = Optional.Absent,
    actionArn: Optional[MitigationActionArn] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.MitigationActionIdentifier = {
    import MitigationActionIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MitigationActionIdentifier
      .builder()
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        actionArn.map(value =>
          MitigationActionArn.unwrap(value): java.lang.String
        )
      )(_.actionArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MitigationActionIdentifier.ReadOnly =
    zio.aws.iot.model.MitigationActionIdentifier.wrap(buildAwsValue())
}
object MitigationActionIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.MitigationActionIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MitigationActionIdentifier =
      zio.aws.iot.model.MitigationActionIdentifier(
        actionName.map(value => value),
        actionArn.map(value => value),
        creationDate.map(value => value)
      )
    def actionName: Optional[MitigationActionName]
    def actionArn: Optional[MitigationActionArn]
    def creationDate: Optional[Timestamp]
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionArn: ZIO[Any, AwsError, MitigationActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MitigationActionIdentifier
  ) extends zio.aws.iot.model.MitigationActionIdentifier.ReadOnly {
    override val actionName: Optional[MitigationActionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionName())
        .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val actionArn: Optional[MitigationActionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionArn())
        .map(value => zio.aws.iot.model.primitives.MitigationActionArn(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MitigationActionIdentifier
  ): zio.aws.iot.model.MitigationActionIdentifier.ReadOnly = new Wrapper(impl)
}
