package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait ModelStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.ModelStatus
}
object ModelStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ModelStatus
  ): zio.aws.iot.model.ModelStatus = value match {
    case software.amazon.awssdk.services.iot.model.ModelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ModelStatus.PENDING_BUILD =>
      val r = PENDING_BUILD
      r
    case software.amazon.awssdk.services.iot.model.ModelStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iot.model.ModelStatus.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ModelStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.ModelStatus =
      software.amazon.awssdk.services.iot.model.ModelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_BUILD extends zio.aws.iot.model.ModelStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.ModelStatus =
      software.amazon.awssdk.services.iot.model.ModelStatus.PENDING_BUILD
  }
  case object ACTIVE extends zio.aws.iot.model.ModelStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.ModelStatus =
      software.amazon.awssdk.services.iot.model.ModelStatus.ACTIVE
  }
  case object EXPIRED extends zio.aws.iot.model.ModelStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.ModelStatus =
      software.amazon.awssdk.services.iot.model.ModelStatus.EXPIRED
  }
}
