package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ResponseTopic,
  ContentType,
  CorrelationData,
  PayloadFormatIndicator,
  MessageExpiry
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MqttHeaders(
    payloadFormatIndicator: Optional[PayloadFormatIndicator] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    responseTopic: Optional[ResponseTopic] = Optional.Absent,
    correlationData: Optional[CorrelationData] = Optional.Absent,
    messageExpiry: Optional[MessageExpiry] = Optional.Absent,
    userProperties: Optional[Iterable[zio.aws.iot.model.UserProperty]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.MqttHeaders = {
    import MqttHeaders.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MqttHeaders
      .builder()
      .optionallyWith(
        payloadFormatIndicator.map(value =>
          PayloadFormatIndicator.unwrap(value): java.lang.String
        )
      )(_.payloadFormatIndicator)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        responseTopic.map(value =>
          ResponseTopic.unwrap(value): java.lang.String
        )
      )(_.responseTopic)
      .optionallyWith(
        correlationData.map(value =>
          CorrelationData.unwrap(value): java.lang.String
        )
      )(_.correlationData)
      .optionallyWith(
        messageExpiry.map(value =>
          MessageExpiry.unwrap(value): java.lang.String
        )
      )(_.messageExpiry)
      .optionallyWith(
        userProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userProperties)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MqttHeaders.ReadOnly =
    zio.aws.iot.model.MqttHeaders.wrap(buildAwsValue())
}
object MqttHeaders {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.MqttHeaders] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MqttHeaders =
      zio.aws.iot.model.MqttHeaders(
        payloadFormatIndicator.map(value => value),
        contentType.map(value => value),
        responseTopic.map(value => value),
        correlationData.map(value => value),
        messageExpiry.map(value => value),
        userProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def payloadFormatIndicator: Optional[PayloadFormatIndicator]
    def contentType: Optional[ContentType]
    def responseTopic: Optional[ResponseTopic]
    def correlationData: Optional[CorrelationData]
    def messageExpiry: Optional[MessageExpiry]
    def userProperties: Optional[List[zio.aws.iot.model.UserProperty.ReadOnly]]
    def getPayloadFormatIndicator: ZIO[Any, AwsError, PayloadFormatIndicator] =
      AwsError.unwrapOptionField(
        "payloadFormatIndicator",
        payloadFormatIndicator
      )
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getResponseTopic: ZIO[Any, AwsError, ResponseTopic] =
      AwsError.unwrapOptionField("responseTopic", responseTopic)
    def getCorrelationData: ZIO[Any, AwsError, CorrelationData] =
      AwsError.unwrapOptionField("correlationData", correlationData)
    def getMessageExpiry: ZIO[Any, AwsError, MessageExpiry] =
      AwsError.unwrapOptionField("messageExpiry", messageExpiry)
    def getUserProperties
        : ZIO[Any, AwsError, List[zio.aws.iot.model.UserProperty.ReadOnly]] =
      AwsError.unwrapOptionField("userProperties", userProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MqttHeaders
  ) extends zio.aws.iot.model.MqttHeaders.ReadOnly {
    override val payloadFormatIndicator: Optional[PayloadFormatIndicator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloadFormatIndicator())
        .map(value =>
          zio.aws.iot.model.primitives.PayloadFormatIndicator(value)
        )
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.iot.model.primitives.ContentType(value))
    override val responseTopic: Optional[ResponseTopic] = zio.aws.core.internal
      .optionalFromNullable(impl.responseTopic())
      .map(value => zio.aws.iot.model.primitives.ResponseTopic(value))
    override val correlationData: Optional[CorrelationData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.correlationData())
        .map(value => zio.aws.iot.model.primitives.CorrelationData(value))
    override val messageExpiry: Optional[MessageExpiry] = zio.aws.core.internal
      .optionalFromNullable(impl.messageExpiry())
      .map(value => zio.aws.iot.model.primitives.MessageExpiry(value))
    override val userProperties
        : Optional[List[zio.aws.iot.model.UserProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.UserProperty.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MqttHeaders
  ): zio.aws.iot.model.MqttHeaders.ReadOnly = new Wrapper(impl)
}
