package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyVersionId, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicyVersionIdentifier(
    policyName: Optional[PolicyName] = Optional.Absent,
    policyVersionId: Optional[PolicyVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier = {
    import PolicyVersionIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly =
    zio.aws.iot.model.PolicyVersionIdentifier.wrap(buildAwsValue())
}
object PolicyVersionIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PolicyVersionIdentifier =
      zio.aws.iot.model.PolicyVersionIdentifier(
        policyName.map(value => value),
        policyVersionId.map(value => value)
      )
    def policyName: Optional[PolicyName]
    def policyVersionId: Optional[PolicyVersionId]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
  ) extends zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly {
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyVersionId: Optional[PolicyVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyVersionId())
        .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
  ): zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly = new Wrapper(impl)
}
