package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{TargetArn, PayloadVersion}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProvisioningHook(
    payloadVersion: Optional[PayloadVersion] = Optional.Absent,
    targetArn: TargetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ProvisioningHook = {
    import ProvisioningHook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ProvisioningHook
      .builder()
      .optionallyWith(
        payloadVersion.map(value =>
          PayloadVersion.unwrap(value): java.lang.String
        )
      )(_.payloadVersion)
      .targetArn(TargetArn.unwrap(targetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ProvisioningHook.ReadOnly =
    zio.aws.iot.model.ProvisioningHook.wrap(buildAwsValue())
}
object ProvisioningHook {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ProvisioningHook
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ProvisioningHook = zio.aws.iot.model
      .ProvisioningHook(payloadVersion.map(value => value), targetArn)
    def payloadVersion: Optional[PayloadVersion]
    def targetArn: TargetArn
    def getPayloadVersion: ZIO[Any, AwsError, PayloadVersion] =
      AwsError.unwrapOptionField("payloadVersion", payloadVersion)
    def getTargetArn: ZIO[Any, Nothing, TargetArn] = ZIO.succeed(targetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningHook
  ) extends zio.aws.iot.model.ProvisioningHook.ReadOnly {
    override val payloadVersion: Optional[PayloadVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloadVersion())
        .map(value => zio.aws.iot.model.primitives.PayloadVersion(value))
    override val targetArn: TargetArn =
      zio.aws.iot.model.primitives.TargetArn(impl.targetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningHook
  ): zio.aws.iot.model.ProvisioningHook.ReadOnly = new Wrapper(impl)
}
