package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.TableName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutItemInput(tableName: TableName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PutItemInput = {
    import PutItemInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PutItemInput
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PutItemInput.ReadOnly =
    zio.aws.iot.model.PutItemInput.wrap(buildAwsValue())
}
object PutItemInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.PutItemInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PutItemInput =
      zio.aws.iot.model.PutItemInput(tableName)
    def tableName: TableName
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PutItemInput
  ) extends zio.aws.iot.model.PutItemInput.ReadOnly {
    override val tableName: TableName =
      zio.aws.iot.model.primitives.TableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PutItemInput
  ): zio.aws.iot.model.PutItemInput.ReadOnly = new Wrapper(impl)
}
