package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AllowAutoRegistration,
  SetAsActive,
  CertificatePem
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterCaCertificateRequest(
    caCertificate: CertificatePem,
    verificationCertificate: Optional[CertificatePem] = Optional.Absent,
    setAsActive: Optional[SetAsActive] = Optional.Absent,
    allowAutoRegistration: Optional[AllowAutoRegistration] = Optional.Absent,
    registrationConfig: Optional[zio.aws.iot.model.RegistrationConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent,
    certificateMode: Optional[zio.aws.iot.model.CertificateMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest = {
    import RegisterCaCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
      .builder()
      .caCertificate(CertificatePem.unwrap(caCertificate): java.lang.String)
      .optionallyWith(
        verificationCertificate.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.verificationCertificate)
      .optionallyWith(
        setAsActive.map(value => SetAsActive.unwrap(value): java.lang.Boolean)
      )(_.setAsActive)
      .optionallyWith(
        allowAutoRegistration.map(value =>
          AllowAutoRegistration.unwrap(value): java.lang.Boolean
        )
      )(_.allowAutoRegistration)
      .optionallyWith(registrationConfig.map(value => value.buildAwsValue()))(
        _.registrationConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegisterCaCertificateRequest.ReadOnly =
    zio.aws.iot.model.RegisterCaCertificateRequest.wrap(buildAwsValue())
}
object RegisterCaCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterCaCertificateRequest =
      zio.aws.iot.model.RegisterCaCertificateRequest(
        caCertificate,
        verificationCertificate.map(value => value),
        setAsActive.map(value => value),
        allowAutoRegistration.map(value => value),
        registrationConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        certificateMode.map(value => value)
      )
    def caCertificate: CertificatePem
    def verificationCertificate: Optional[CertificatePem]
    def setAsActive: Optional[SetAsActive]
    def allowAutoRegistration: Optional[AllowAutoRegistration]
    def registrationConfig
        : Optional[zio.aws.iot.model.RegistrationConfig.ReadOnly]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def certificateMode: Optional[zio.aws.iot.model.CertificateMode]
    def getCaCertificate: ZIO[Any, Nothing, CertificatePem] =
      ZIO.succeed(caCertificate)
    def getVerificationCertificate: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField(
        "verificationCertificate",
        verificationCertificate
      )
    def getSetAsActive: ZIO[Any, AwsError, SetAsActive] =
      AwsError.unwrapOptionField("setAsActive", setAsActive)
    def getAllowAutoRegistration: ZIO[Any, AwsError, AllowAutoRegistration] =
      AwsError.unwrapOptionField("allowAutoRegistration", allowAutoRegistration)
    def getRegistrationConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      AwsError.unwrapOptionField("registrationConfig", registrationConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCertificateMode
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateMode] =
      AwsError.unwrapOptionField("certificateMode", certificateMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
  ) extends zio.aws.iot.model.RegisterCaCertificateRequest.ReadOnly {
    override val caCertificate: CertificatePem =
      zio.aws.iot.model.primitives.CertificatePem(impl.caCertificate())
    override val verificationCertificate: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationCertificate())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val setAsActive: Optional[SetAsActive] = zio.aws.core.internal
      .optionalFromNullable(impl.setAsActive())
      .map(value => zio.aws.iot.model.primitives.SetAsActive(value))
    override val allowAutoRegistration: Optional[AllowAutoRegistration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowAutoRegistration())
        .map(value => zio.aws.iot.model.primitives.AllowAutoRegistration(value))
    override val registrationConfig
        : Optional[zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationConfig())
        .map(value => zio.aws.iot.model.RegistrationConfig.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
    override val certificateMode: Optional[zio.aws.iot.model.CertificateMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateMode())
        .map(value => zio.aws.iot.model.CertificateMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest
  ): zio.aws.iot.model.RegisterCaCertificateRequest.ReadOnly = new Wrapper(impl)
}
